package com.yeejoin.amos.bank.dao.repository;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;
import org.springframework.transaction.annotation.Transactional;

@Repository("iAlarmDao")
public interface IAlarmRepository extends IBaseRepository<Alarm, String> {

	@Query(value="select * from spc_alarm where query_column =?1 AND current_state in ('未确认未清除','已确认未清除','异常','告警')",nativeQuery=true )
	public List<Alarm> selectByQueryColumn(String type);
	
	@Query(value="select COUNT(*) value,sa.alarm_level name, sa.org_code orgCode from  spc_alarm sa where sa.org_code like CONCAT('%', ?1, '%' )  and sa.current_state in ('未确认未清除','已确认未清除','异常','告警')  GROUP BY sa.alarm_level, sa.org_code",nativeQuery=true )
	public List<Map<String, Object>> countnum(String code);
}


