package com.yeejoin.amos.bank.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.TopographyNode;
import com.yeejoin.amos.op.core.jpa.IBaseRepository;

@Repository("iTopographyNodeDao")
public interface ITopographyNodeRepository extends IBaseRepository<TopographyNode, String> {
	
	@Query(value="select * from b_topography_node where org_code  like concat(?1,'%')  and treeid =?2 and type =?3",nativeQuery=true )
	List<TopographyNode> findByOrgCodeAndTreeidAndType(String orgcode,String treeid, int type);
	@Query(value="select * from b_topography_node where  org_code  like concat(?1,'%')   and type =?2",nativeQuery=true )
	List<TopographyNode> findByOrgCodeAndType(String orgcode,int type);
	
	TopographyNode findBySourceId(String sourceId);

	TopographyNode findBySourceIdAndTreeid(String fromSourceId, String treeId);

	TopographyNode findByTextAndTreeidAndIsGroup(String groupName, String treeIdStr, boolean b);

	TopographyNode findBySourceIdAndTreeidAndGroup(String toSourceId, String treeIdStr, String groupKey);

	TopographyNode findBySourceIdAndType(String sourceId, int type);
}
