package com.yeejoin.amos.bank.remote;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.bank.common.enums.DeviceUriEnum;
import com.yeejoin.amos.bank.remote.client.DeviceRemoteClient;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service
public class RemoteDeviceService {

    private static final Logger log = org.apache.log4j.Logger.getLogger(RemoteDeviceService.class);

//    @Value("${params.device.address}")
//    private String address;

    @Autowired
    private DeviceRemoteClient deviceRemoteClient;

    private String buildUrl(String address, DeviceUriEnum deviceUriEnum, Map<String, String> map) {
        String uri = deviceUriEnum.getUri();
        String params = deviceUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }


//    public String dynamicRingData(DeviceUriEnum deviceUriEnum, String token, String json) {
//        String url = buildUrl(address, deviceUriEnum, null);
//        return HttpUtil.doPostJson(url, json, token);
//    }
//
//    public String deviceDoGetWithToken(DeviceUriEnum deviceUriEnum, String token, Map<String, String> params) {
//        String url = buildUrl(address, deviceUriEnum, params);
//        return HttpUtil.doGet(url);
//    }
//
//    public String deviceDoGet(DeviceUriEnum deviceUriEnum, Map<String, String> params) {
//        String url = buildUrl(address, deviceUriEnum, params);
//        return HttpUtil.doGet(url);
//    }

    public String selectEquipments(String params) {
        try {
            Object result = deviceRemoteClient.selectEquipments(params);
            return JSON.toJSONString(result);
        } catch (InnerInvokException e) {
            log.error("selectEquipments fail " + e.getMessage());
        }
        return null;
    }

    public String listByOrgCodeAndModel(String orgCode, String model) {
        try {
            Object result = deviceRemoteClient.listByOrgCodeAndModel(orgCode, model);
            return JSON.toJSONString(result);
        } catch (InnerInvokException e) {
            log.error("selectEquipById fail " + e.getMessage());
        }
        return null;
    }

    public String selectEquipById(Long id) {
        try {
            Object result = deviceRemoteClient.selectEquipById(String.valueOf(id));
            return JSON.toJSONString(result);
        } catch (InnerInvokException e) {
            log.error("selectEquipById fail " + e.getMessage());
        }
        return null;
    }
}
