package com.yeejoin.amos.bank.remote.client;

import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * @author DELL
 *
 */
@FeignClient(name = "${Risk.fegin.name}")
public interface RiskModelRemoteClient {

	/**
	 * 修改rpn值
	 */
	@RequestMapping(value = "api/risksource/update/fireqeuiment/sod", method = RequestMethod.GET, consumes = "application/json")
	CommonResponse updateEquipmentAlarmData(@RequestParam(value = "riskFactorID") Long riskFactorID,
			 @RequestParam("equipmentName") String equipmentName,@RequestParam("state") Integer state)
			throws InnerInvokException;

    /**
     * 根据风险因素id查询巡检点和指标项目列表
     */
    @RequestMapping(value = "/api/risksource/getEquiments/points", method = RequestMethod.GET, consumes="application/json" )
    CommonResponse listPointInputitemByFactorId(@RequestParam(value = "factorId") Long factorId) throws InnerInvokException;
    
    
    /**
     * 根据风险因素id查询设备和指标项列表
     */
    @RequestMapping(value = "/api/risksource/getFactorBindPoints", method = RequestMethod.GET, consumes="application/json" )
    CommonResponse queryBoundByFactroId(@RequestParam(value = "factorId") Long factorId) throws InnerInvokException;
}
