package com.yeejoin.amos.bank.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.google.common.base.Joiner;
import org.apache.commons.io.FileUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: xinglei
 * @Description: TODO()
 * @Date: 2019/12/3 19:36
 */
public class JsonUtil {

    public static JSONArray getJsonArray(String jsonPath) {
        File jsonFile = null;
        String json = "";
        try {
            jsonFile = ResourceUtils.getFile(String.format("classpath:json/%s", jsonPath));
            json = FileUtils.readFileToString(jsonFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONArray jsonArray = JSON.parseArray(json);
        return jsonArray;
    }

    public static JSONObject getJsonObject(String jsonPath) {
        File jsonFile = null;
        String json = "";
        try {
            jsonFile = ResourceUtils.getFile(String.format("classpath:json/%s", jsonPath));
            json = FileUtils.readFileToString(jsonFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject parseObject = JSON.parseObject(json);
        return parseObject;
    }


    //classpath:json/donghuanAlarm.json
    public static String readJsonFile(String path) {
        try {
            File jsonFile = ResourceUtils.getFile(path);
            String json = FileUtils.readFileToString(jsonFile);
            return json;
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 去除json中多余的转义符号
     *
     * @param paramString
     * @return
     */
    public static String formatJsonString(String paramString) {
        // 序列化为JSON字符串
        String data02 = JSON.toJSONString(paramString);
        System.out.println("data02:" + data02);
        // 通过 replace 去掉斜杠
        String data03 = data02.replace("\\", "");
        System.out.println("data03:" + data03);
        // 去掉首尾的引号
        String data04 = data03.substring(1, data03.length() - 1);
        System.out.println("data04:" + data04);
        // 去掉首尾的引号
        if (data04.startsWith("{") && data04.endsWith("}")) {
            return data04;
        } else {
            String data05 = data03.substring(2, data04.length());
            System.out.println("data05:" + data05);
            return data05;
        }
    }

    public static  String[] toStringArray(String fields) {
        fields = fields.replace("\"", "");
        String[] field = null;
        if (fields != null && fields.length() > 0) {
            field = fields.split(",");
            String first = field[0];
            field[0] = first.substring(first.indexOf("[") + 1);
            String last = field[field.length - 1];
            field[field.length - 1] = last.substring(0, last.indexOf("]"));
        }
        String[] objects = Arrays.stream(field).filter(x -> !x.isEmpty() && !x.equals("null")).toArray(String[]::new);
        return objects;
    }

    public static String arraysToString(String[] str){
        String result = null;
        for(int i = 0; i < str.length; i++) {
            str[i] = str[i].replace(" ", "");
            if (ObjectUtils.isEmpty(result)){
                result = "#" + str[i];
            } else {
                result = result + "#" + str[i];
            }
        }
        return result;
    }
}
