package com.yeejoin.amos.bank.webSocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.common.enums.AbnormalStateEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.common.enums.FireDetectionAlarmType;
import com.yeejoin.amos.bank.common.enums.TopoNodeTypeEnum;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.remote.client.PatrolRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.ITopographyService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.utils.JsonUtil;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.spc.exception.YeeException;

/**
 * 火探告警
 *
 * @author DELL
 */
public class FireDetectionWebSocketClient extends WebSocketClient {

    private static final Logger log = Logger.getLogger(FireDetectionWebSocketClient.class);

    private IAlarmPointService alarmPointService;
    private IAlarmService alarmService;
    private ITopographyService iTopographyService;
    private AmosWsClient client;
    private IAlarmRepository iAlarmDao;
    private static final String TAB = "\r\n";

//    @Value("${params.patrol}")
//    private String address;
    private static ApplicationContext allpicationContext;
    
    private PatrolRemoteClient patrolRemoteClient;

    public static void setAllpicationContext(ApplicationContext context) {
        allpicationContext = context;
    }

    public FireDetectionWebSocketClient(String url) throws URISyntaxException {
        super(new URI(url));
    }

    @Override
    public void onOpen(ServerHandshake shake) {
        log.info("FireDetectionWebSocketClient Shake hands......");
        for (Iterator<String> it = shake.iterateHttpFields(); it.hasNext(); ) {
            String key = it.next();
            log.info(key + ":" + shake.getFieldValue(key));
        }

        alarmPointService = (IAlarmPointService) allpicationContext.getBean(IAlarmPointService.class);
        iTopographyService = (ITopographyService) allpicationContext.getBean(ITopographyService.class);
        client = (AmosWsClient) allpicationContext.getBean(AmosWsClient.class);
        alarmService = (IAlarmService) allpicationContext.getBean(IAlarmService.class);
        patrolRemoteClient= (PatrolRemoteClient) allpicationContext.getBean(PatrolRemoteClient.class);
        iAlarmDao =(IAlarmRepository) allpicationContext.getBean(IAlarmRepository.class);


		try {
			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
//			address = (String) props.get("params.patrol");
		} catch (IOException e) {
			e.printStackTrace();
		}
    }

    @Override
    @Transactional
    public void onMessage(String paramString) {
        try {
//        	paramString = "{\"secondaryType\":\"TCP\",\"subgraphId\":46,\"level\":3,\"isDelete\":false,\"count\":1,\"type\":2,\"equipmentAttrs\":{\"sourceId\":\"100002\",\"deviceType\":\"windows\",\"build\":\"build_1\",\"position\":\"262.85694657784626, 94.69270324707031, 166.98686605919656\",\"storey\":\"floor_3\",\"affiliatedSystem\":\"火探\"},\"descr\":\" TCP不通！\",\"orgCode\":\"1*2\",\"raiseTime\":1579504304992,\"name\":\"服务器-001\",\"eqpId\":195,\"status\":2}";
        	String formatJsonString = JsonUtil.formatJsonString(paramString);
            JSONObject msgJson = JSONObject.parseObject(formatJsonString);
            String equipmentAttrsJson = msgJson.getString("equipmentAttrs");
            if(equipmentAttrsJson != null && !"".equals(equipmentAttrsJson)) {
            	JSONObject equipmentAttrs = JSONObject.parseObject(equipmentAttrsJson);
            	String affiliatedSystem = equipmentAttrs.getString("affiliatedSystem");
            	if(affiliatedSystem != null && "火探".equals(affiliatedSystem)) {
            		log.info("Received message：" + paramString);
            		
            		Long eqpId = msgJson.getLong("eqpId");
            		String status = msgJson.getString("status");
            		String sourceId = equipmentAttrs.getString("sourceId");
            		String alramContent = msgJson.getString("descr");
					String eqpName = msgJson.getString("name");
					Integer level = msgJson.getInteger("level") != null ? msgJson.getInteger("level") : 1;
            		if (eqpId != null && status != null && !"".equals(status) && sourceId != null && !"".equals(sourceId)) {
            			synchronized (this) {
            				
            				List<AlarmPoint> pointList = alarmPointService.selectPointTypeAndPointId(AlarmPointTypeEnum.火探.getCode(), eqpId);
            				if (!FireDetectionAlarmType.产生.getCode().equals(status)) {
            					alarmPointService.deleteItems(pointList);
            					log.info("Clear alarm data  ...success");
//            					iTopographyService.sendAbnormal(eqpId, 0);
            					iTopographyService.sendAbnormalByType(String.valueOf(eqpId), 
										AbnormalStateEnum.N.getCode(), 
										TopoNodeTypeEnum.动环监控.getType(),
										alramContent);
            				} else {
            					if (null == pointList || pointList.size() == 0) {
            						
            						AlarmPoint alarmPoint = new AlarmPoint();
            						alarmPoint.setPointId(eqpId);
            						alarmPoint.setSourceId(sourceId);
            						alarmPoint.setPointType(AlarmPointTypeEnum.火探.getCode());
            						alarmPoint.setUpdateDate(new Date());
            						alarmPoint.setContent(alramContent);
            						alarmPoint.setPointAttrs(equipmentAttrsJson);
            						alarmPoint.setPointName(eqpName);
            						alarmPoint.setCode(msgJson.getString("orgCode"));
            						alarmPointService.saveItem(alarmPoint);
            						log.info("Save alarm data    ...success");
            						
            						//String url = address + "api/msgSubscribe/alarmNotification";
            						try {
										Map<String, Object> map = new HashMap<String, Object>();
										map.put("code", msgJson.getString("orgCode"));
										map.put("body", "告警源名称：" + eqpName + TAB + "告警信息" + alramContent);
										String stringJson = JSONObject.toJSONString(map);
										CommonResponse result = patrolRemoteClient.sendAlarmNotification(stringJson);
										//HttpUtil.PostJson(url, stringJson);
										log.info("手机推送告警信息...success");
									} catch (Exception e) {
										log.info("手机推送告警信息失败...fail" + e.getMessage());
									}
            						
            					}
            					String alarmLevel = AbnormalStateEnum.getAbnormalName(level);
//            					AbnormalStateEnum enum1 = AbnormalStateEnum.getEnum(alarmLevel);
//            					iTopographyService.sendAbnormal(eqpId, enum1 == null ? 0 : enum1.getCode());
            					
            					AbnormalStateEnum enum1 = AbnormalStateEnum.getEnum(alarmLevel);
            					iTopographyService.sendAbnormalByType(String.valueOf(eqpId), enum1 == null ? 0 : enum1.getCode(),
            							TopoNodeTypeEnum.动环监控.getType(), alramContent);
            				}
            				//推送前端告警信息
            				Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
            				List<AlarmPoint> alarms = alarmPointService.findAll(sort);
            				WebsocketParam param = new WebsocketParam("alarmPoint", JSON.toJSONString(alarms));
            				Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
                            String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
                            HttpUtil.PostJson(url, JSON.toJSONString(param));
            				log.info("send websocekt info：" + param);
            				
            				//告警记录
            				String queryColumn = eqpId + "_" + msgJson.getString("type");
            				List<Alarm> curAlarmList = alarmService.findByQueryColumn(queryColumn);
            				SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            				if (curAlarmList != null && curAlarmList.size() > 0) {
            					Alarm alarm = curAlarmList.get(0);
            					alarm.setUpdateDate(df.format(new Date()));
            					alarm.setAlarmReason(alramContent);
            					alarm.setCurrentState(FireDetectionAlarmType.getEnumStatus(status));
            					//alarmService.save(alarm);
            					iAlarmDao.save(alarm);
            					log.info("Update alarm records ...success");
            				} else {
            					Alarm alarm = new Alarm();
            					alarm.setSourceId(sourceId);
            					alarm.setAlarmLevel(AbnormalStateEnum.getAbnormalName(level));
            					alarm.setAlarmReason(alramContent);
            					alarm.setAlarmSourceIp(msgJson.getString("alarmSourceIp"));
            					alarm.setAlarmSourceName(eqpName);
            					alarm.setAlarmSourceType(AlarmPointTypeEnum.火探.getName());
            					alarm.setCurrentState(FireDetectionAlarmType.getEnumStatus(status));
            					Date date = new Date(msgJson.getLong("raiseTime"));
            					alarm.setHappenDate(df.format(date));
            					alarm.setOrgCode(msgJson.getString("orgCode"));
            					alarm.setUpdateDate(df.format(new Date()));
            					alarm.setQueryColumn(queryColumn);
            					//alarmService.save(alarm);
            					iAlarmDao.save(alarm);
            					log.info("Save alarm records...success");
            				}
            			}
            		}else {
            			throw new YeeException("eqpId/sourceId/status 不能为空！！！");
            		}
            	}
            }
        } catch (Exception e) {
            log.info("*****************error**************************");
            log.info(e.getMessage());
        }
    }

    @Override
    public void onClose(int paramInt, String paramString, boolean paramBoolean) {
        log.info("shut down...");
    }

    @Override
    public void onError(Exception e) {
        log.info("abnormal" + e);

    }

    public static synchronized void synFireDetection() {
        System.out.println("-------------------FireDetection alarms Socket start-------------------------");
        try {
            Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
            String FireDetectionWebSocketClientUrl = (String) props.get("params.remoteWebsocketUrl") + "metricData?subData=equipmentData";
            FireDetectionWebSocketClient client = new FireDetectionWebSocketClient(FireDetectionWebSocketClientUrl);
            client.connect();
            while (!client.getReadyState().equals(WebSocket.READYSTATE.OPEN)) {
                System.out.println("Connecting..FireDetection----" + client.getReadyState());
            }
            System.out.println("build..." + FireDetectionWebSocketClientUrl + " connected");
        } catch (URISyntaxException | IOException e) {
            e.printStackTrace();
        }
    }
}
