package com.yeejoin.amos.bank.webSocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.common.enums.AlarmPointEnum;
import com.yeejoin.amos.bank.common.enums.AlarmPointTypeEnum;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.remote.client.PatrolRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.ITopographyService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.utils.JsonUtil;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.spc.exception.YeeException;

/**
 * 接收动环告警
 *
 * @author DELL
 */
public class MonitorAlarmWebSocketClient extends WebSocketClient {

    private static final Logger log = Logger.getLogger(MonitorAlarmWebSocketClient.class);

    private IAlarmPointService alarmPointService;
    private IAlarmService alarmService;
    private ITopographyService iTopographyService;
    private AmosWsClient client;
    private static final String TAB = "\r\n";
    
	private IAlarmRepository iAlarmDao;

    private String address;

    private static ApplicationContext allpicationContext;
    
    private PatrolRemoteClient patrolRemoteClient;

    public static void setAllpicationContext(ApplicationContext context) {
        allpicationContext = context;
    }

    public MonitorAlarmWebSocketClient(String url) throws URISyntaxException {
        super(new URI(url));
    }

    @Override
    public void onOpen(ServerHandshake shake) {
        log.info("MonitorAlarmWebSocketClient Shake hands...");
        for (Iterator<String> it = shake.iterateHttpFields(); it.hasNext(); ) {
            String key = it.next();
            log.info(key + ":" + shake.getFieldValue(key));
        }
        alarmPointService = (IAlarmPointService) allpicationContext.getBean(IAlarmPointService.class);
        iTopographyService = (ITopographyService) allpicationContext.getBean(ITopographyService.class);
        client = (AmosWsClient) allpicationContext.getBean(AmosWsClient.class);
        alarmService = (IAlarmService) allpicationContext.getBean(IAlarmService.class);
        patrolRemoteClient= (PatrolRemoteClient) allpicationContext.getBean(PatrolRemoteClient.class);
        iAlarmDao =(IAlarmRepository) allpicationContext.getBean(IAlarmRepository.class);

		try {
			Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
			address = (String) props.get("params.patrol");
		} catch (IOException e) {
			e.printStackTrace();
		}
    }

    @Override
    @Transactional
    public void onMessage(String paramString) {
        try {
            log.info("Received message：" + paramString);
            String formatJsonString = JsonUtil.formatJsonString(paramString);
            JSONObject msgJson = JSONObject.parseObject(formatJsonString);
            Long eqpId = msgJson.getLong("eqpId");
            if (null != eqpId) {
                String curStatus = msgJson.getString("currentState");
                

                List<JSONObject> alarmAttributes = (List<JSONObject>) msgJson.get("capacityAttrList");
                synchronized (this) {

                    Boolean alarmFlagBoolean = false;
                    for (JSONObject a : alarmAttributes) {
                        String atr = (String) a.get("name");
                        String res = (String) msgJson.get(atr);
                        if (res != null && AlarmPointEnum.异常.getName().equals(res)) {
                            alarmFlagBoolean = true;
                            log.info("Moving ring device[" + eqpId + "]" + atr + "abnormal");
                            break;
                        }
                    }
                    List<AlarmPoint> pointList = alarmPointService.selectPointTypeAndPointId(AlarmPointTypeEnum.动环.getCode(), eqpId);
                    if (!alarmFlagBoolean && pointList != null) {
                        alarmPointService.deleteItems(pointList);
                        log.info("Clear p_alarm_point  Alarm data ...success");
                        iTopographyService.sendAbnormal(msgJson.getString("sourceId"), 0);
                    } else {
                        if (null == pointList || pointList.size() == 0) {
                            String alramContent = msgJson.getString("describe");
                            String eqpType = msgJson.getString("eqpType");
                            String eqpName = msgJson.getString("eqpName");
                            String equipmentAttrs = msgJson.getString("equipmentAttrs");
                            String sourceId = msgJson.getString("sourceId");
                            String orgCode = msgJson.getString("orgCode");
                            AlarmPoint alarmPoint = new AlarmPoint();
                            alarmPoint.setCode(orgCode);
                            alarmPoint.setPointId(eqpId);
                            //    					alarmPoint.setPointType(eqpType);
                            alarmPoint.setPointType(AlarmPointTypeEnum.动环.getCode());
                            alarmPoint.setUpdateDate(new Date());
                            alarmPoint.setContent(alramContent);
                            alarmPoint.setPointAttrs(equipmentAttrs);
                            alarmPoint.setPointName(eqpName);
                            alarmPointService.saveItem(alarmPoint);
                            log.info("Save alarm data....success");

                            //推送消息巡检app
                            //String url = address + "api/msgSubscribe/alarmNotification";
                            try {
								Map<String, Object> map = new HashMap<String, Object>();
								map.put("code", msgJson.getString("orgCode"));
								map.put("body", "告警源名称：" + eqpName + TAB + "告警信息" + alramContent);
								String stringJson = JSONObject.toJSONString(map);
								//HttpUtil.PostJson(url, stringJson);
								CommonResponse result = patrolRemoteClient.sendAlarmNotification(stringJson);
								log.info("手机推送告警信息...success");
							} catch (Exception e) {
								log.info("手机推送告警信息失败...fail" + e.getMessage());
							}
                        }
                        iTopographyService.sendAbnormal(msgJson.getString("sourceId"), 1);
                    }
                    Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
                    List<AlarmPoint> alarms = alarmPointService.findAll(sort);
                    
                    WebsocketParam param = new WebsocketParam("alarmPoint", JSON.toJSONString(alarms));
                    Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
                    String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
                    HttpUtil.PostJson(url, JSON.toJSONString(param));
                    log.info("send websocekt info：" + param);

                    //告警记录
                    ArrayList<Alarm> alarmList = new ArrayList<>();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (JSONObject atrJson : alarmAttributes) {
                        String atrName = (String) atrJson.get("name");
                        String alarmType = (String) atrJson.get("displayName");
                        String res = (String) msgJson.get(atrName);
                        if ("labelType".equals(atrName)) {
                            continue;
                        }

                        //告警记录
                        String queryColumn = msgJson.getString("sourceId") + "_" + alarmType;
                        //查出当前记录中的告警记录
                        List<Alarm> curAlarmList = alarmService.findByQueryColumn(queryColumn);
                        if (curAlarmList != null && curAlarmList.size() > 0) {

                            Alarm alarm = curAlarmList.get(0);
//	    					if(alarm != null || AlarmPointEnum.异常.getName().equals(res)) {
                            alarm.setUpdateDate(df.format(new Date()));
                            alarm.setCurrentState(res);
                            alarmList.add(alarm);
//	    					}
                        } else {//记录无告警则新增
                            Alarm alarm = new Alarm();
                            alarm.setSourceId(msgJson.getString("sourceId"));
                            alarm.setAlarmSourceIp(msgJson.getString("sourceId"));
                            alarm.setAlarmSourceType(alarmType);
                            alarm.setUpdateDate(df.format(new Date()));
                            alarm.setOrgCode(msgJson.getString("orgCode"));
                            alarm.setQueryColumn(queryColumn);
                            alarm.setAlarmLevel("警告告警");
                            alarm.setCurrentState(res);
                            alarmList.add(alarm);
                        }

                    }
                	//alarmService.save(alarmList);
                    iAlarmDao.saveAll(alarmList);
                    log.info("Save alarm records ....success");
                }
            }else {
				throw new YeeException("eqpId 不能为空！！！");
			}
            
        } catch (Exception e) {
            log.info("*********************error****************************");
            log.info(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onClose(int paramInt, String paramString, boolean paramBoolean) {
        log.info("close ...");
    }

    @Override
    public void onError(Exception e) {
        log.info("abnormal " + e);
    }

    public static synchronized void synMonitorAlarmPoint() {
        System.out.println("-------------------Monitoring of ring alarms start-------------------------");
        try {
            Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
            String monitorAlarmWebSocketClientUrl = (String) props.get("params.remoteWebsocketUrl") + "metricData?subData=monitorAlarm";
            MonitorAlarmWebSocketClient client = new MonitorAlarmWebSocketClient(monitorAlarmWebSocketClientUrl);
            client.connect();
            while (!client.getReadyState().equals(WebSocket.READYSTATE.OPEN)) {

                System.out.println("connecting...Dynamic ring alarm----" + client.getReadyState());
            }
            System.out.println("build " + monitorAlarmWebSocketClientUrl + "connected...");
        } catch (URISyntaxException | IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}
