package com.yeejoin.amos.spc.business.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;

import com.yeejoin.amos.spc.exception.YeeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.spc.core.util.StringUtil;

import springfox.documentation.annotations.ApiIgnore;

/**
 * 基础控制器
 *
 * @author
 */
@ApiIgnore
@RestController
@RequestMapping("/base")
public class BaseController {

	@Autowired
	Privilege privilege;

	@Autowired
	protected HttpServletRequest request;

	@Autowired
	private RedisTemplate<String, String> redisTemplate;

	/**
	 * 获取token
	 * 
	 * @return
	 */
	protected String getToken() {
		String token = request.getHeader("token");
		return token;
	}

	protected String getLoginOrgCode(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
//        if (reginParams.getDepartment() != null) {
//            return reginParams.getDepartment().getDeptOrgCode();
//        }
		if (reginParams.getCompany() != null) {
			return reginParams.getCompany().getOrgCode();
		}
		return null;
	}

	protected String getRoleTypeName(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getRole() != null) {
			return reginParams.getRole().getRoleName();
		}
		return null;
	}

	protected Long getDepartmentId(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getDepartment() != null) {
			return reginParams.getDepartment().getSequenceNbr();
		}
		return null;
	}

	protected String getCompanyId(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getCompany() != null) {
			return String.valueOf(reginParams.getCompany().getSequenceNbr());
		}
		return null;
	}

	protected String getCompanyName(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getCompany() != null) {
			return reginParams.getCompany().getCompanyName();
		}
		return null;
	}

	protected String getOrgCode() {
		if (getUserInfo() == null) {
			return "";
		}
		return getSelectedOrgInfo().getCompany().getOrgCode();
	}

	private String buildKey(String userId, String token) {
		System.out.println("region_" + userId + "_" + token);
		return "region_" + userId + "_" + token;
		//return "region_" + userId + "_" + token.substring(0, token.indexOf('-', 1));
	}

	protected void saveSelectedOrgInfo(ReginParams reginParams) {
		redisTemplate.opsForValue().set(buildKey(getUserId(), getToken()), JSONObject.toJSONString(reginParams));

	}

	protected ReginParams getSelectedOrgInfo() {
		return JSON.parseObject(redisTemplate.opsForValue().get(buildKey(getUserId(), getToken())), ReginParams.class);
	}

	/**
	 * 当前登录用户信息
	 */
	protected AgencyUserModel getUserInfo() {

		try {
			String token = request.getHeader("token");
			String product = request.getHeader("product");
			String appKey = request.getHeader("appKey");
			RequestContext.setToken(token);
			RequestContext.setProduct(product);
			RequestContext.setAppKey(appKey);
			AgencyUserModel result = Privilege.agencyUserClient.getme().getResult();
			return result;
		} catch (InnerInvokException e) {
			System.err.println("get user info fail");
			throw new YeeException(e.getMessage());
		}
	}

	protected String getUserId() {
		return getUserInfo().getUserId();
	}

	/**
	 * 生成查询条件
	 *
	 * @param queryRequests 前端查询条件 是否过滤机构标志 true过滤 false不过滤
	 * @return
	 */
	public List<DaoCriteria> buildDaoCriterias(List<CommonRequest> queryRequests) {
		List<DaoCriteria> daoCriterias = new ArrayList<DaoCriteria>();
		if (queryRequests != null && !queryRequests.isEmpty()) {
			for (CommonRequest query : queryRequests) {
				DaoCriteria criteria = new DaoCriteria();
				if (StringUtil.isNotEmpty(query.getValue())) {
					criteria.setPropertyName(query.getName());
					String column = criteria.getPropertyName();
					if (!(query.getValue() instanceof Collection<?>)
							&& column.substring(column.length() - 2, column.length()).toUpperCase().equals("ID")) {
						try {
							criteria.setValue(Long.valueOf(query.getValue().toString()));
						} catch (NumberFormatException e) {
							criteria.setValue(query.getValue());
						}
					} else {
						criteria.setValue(query.getValue());
					}

					String operator = query.getType();
					if (!StringUtil.isNotEmpty(operator)) {
						criteria.setOperator(QueryOperatorEnum.EQUAL.getName());
					} else if (operator.equals(QueryOperatorEnum.LIKE.getName())) {
						setLikeCriteria(criteria, query);
					} else if (operator.equals(QueryOperatorEnum.BIGGER_EQUAL.getName())) {
						criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
					} else if (operator.equals(QueryOperatorEnum.LESS_EQUAL.getName())) {
						criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
					} else if (QueryOperatorEnum.getEnum(operator) != null) {
						criteria.setOperator(QueryOperatorEnum.getEnum(operator).getName());
					} else {
						criteria.setOperator(operator);
					}
					daoCriterias.add(criteria);
				}
			}
		}
		return daoCriterias;
	}

	/**
	 * 暂时未用到
	 * 
	 * @return
	 */
//	public List<DaoCriteria> buildDaoCriteriasNoParam() {
//		List<DaoCriteria> daoCriterias = new ArrayList<DaoCriteria>();
//		String orgCode = getOrgCode();
//		if(isDirector()){
//			daoCriterias = buildOrgDaoCriteriaInChildren(daoCriterias,orgCode);
//		}else{
//			daoCriterias = buildOrgDaoCriteriaOutChildren(daoCriterias,orgCode);
//		}
//		return daoCriterias;
//	}

	/**
	 * <pre>
	 * 生成通过当前用户所属组织机构（包含子机构）过滤的查询条件
	 * </pre>
	 *
	 * @param daoCriterias 查询条件集合
	 * @return
	 */
	public List<DaoCriteria> buildOrgDaoCriteriaInChildren(List<DaoCriteria> daoCriterias, String orgCode) {

		// 添加所属公司的过滤条件
		DaoCriteria compDaoCriteria = new DaoCriteria();
		compDaoCriteria.setPropertyName("orgCode");
		compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
		compDaoCriteria.setValue(orgCode);
		daoCriterias.add(compDaoCriteria);

		// 添加子公司下的过滤条件
		DaoCriteria childCompDaoCriteria = new DaoCriteria();
		childCompDaoCriteria.setPropertyName("orgCode");
		childCompDaoCriteria.setOperator(QueryOperatorEnum.LIKE.getName());
		childCompDaoCriteria.setValue(orgCode + "*%");
		daoCriterias.add(childCompDaoCriteria);
		return daoCriterias;
	}

	/**
	 * <pre>
	 * 生成通过当前用户所属组织机构（不包含子机构）过滤的查询条件
	 * </pre>
	 *
	 * @param daoCriterias 查询条件集合
	 * @param orgCode
	 * @return
	 */
	public List<DaoCriteria> buildOrgDaoCriteriaOutChildren(List<DaoCriteria> daoCriterias, String orgCode) {
		/**
		 * 当前用户所属公司
		 */

		DaoCriteria compDaoCriteria = new DaoCriteria();
		compDaoCriteria.setPropertyName("orgCode");
		compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
		compDaoCriteria.setValue(orgCode);
		daoCriterias.add(compDaoCriteria);
		return daoCriterias;
	}

	/**
	 * 对like查询语句的内容进行特殊字符转义
	 *
	 * @param criteria
	 * @param query
	 */
	@SuppressWarnings("unchecked")
	public void setLikeCriteria(DaoCriteria criteria, CommonRequest query) {
		if (query.getValue() instanceof List) {
			List<String> value = (List<String>) query.getValue();
			if (!value.isEmpty()) {
				value = value.stream().map(s -> {
					String str = s.replace("%", "/%").replace("_", "/_");
					return "%" + str + "%";
				}).collect(Collectors.toList());
				criteria.setValue(value);
				criteria.setOperator(QueryOperatorEnum.LIKE.getName());
			}
		} else {
			String value = (String) query.getValue();
			if (value != null) {
				value = value.replace("%", "/%").replace("_", "/_");
				criteria.setValue("%" + value + "%");
				criteria.setOperator(QueryOperatorEnum.LIKE.getName());
			}
		}
	}

	/**
	 * <pre>
	 * 提取错误异常中的错误消息
	 * </pre>
	 *
	 * <p>
	 * 当实体类中对属相注解了以下类似的注解，需要用try.catch语句捕获异常，使用 #getErrorMessage(Exception)
	 * 提取出异常信息NotNull(message = "属性不能为空！")
	 * </p>
	 *
	 * @param e
	 * @return
	 * @see {@code NotBlank} ... NotNull、NotEmpty...
	 * @see {@code Valid}
	 */
	public String getErrorMessage(Exception e) {
		StringBuilder message = new StringBuilder();
		if (e instanceof TransactionSystemException) {
			TransactionSystemException exception = (TransactionSystemException) e;
			if (exception.getRootCause() instanceof ConstraintViolationException) {
				ConstraintViolationException root = (ConstraintViolationException) exception.getRootCause();
				root.getConstraintViolations().forEach(constraintViolation -> {
					message.append(constraintViolation.getMessageTemplate());
				});
			} else {
				message.append(e.getMessage());
			}
		} else if (e instanceof ConstraintViolationException) {
			((ConstraintViolationException) e).getConstraintViolations()
					.forEach(constraintViolation -> message.append(constraintViolation.getMessageTemplate()));
		} else {
			message.append("操作异常！");
		}
		return message.toString();
	}

}
