package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.utils.HttpUtil;
import com.yeejoin.amos.bank.webSocket.AmosWsClient;
import com.yeejoin.amos.bank.webSocket.WebsocketParam;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.bo.RiskFactorBo;
import com.yeejoin.amos.spc.business.feign.RemoteRuleServer;
import com.yeejoin.amos.spc.business.rulemodel.HiddenTroubleRo;
import com.yeejoin.amos.spc.business.rulemodel.ProtalDataRo;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskFactorService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/protal")
@Api(tags = "巡检信息推送")
public class ProtalDataController extends BaseController {

    private static final Logger log = Logger.getLogger(ProtalDataController.class);

    @Autowired
    private RemoteRuleServer remoteRuleServer;
    @Autowired
    private AmosWsClient client;

    @Autowired
    private ISpcRiskFactorService iSpcRiskFactorService;

    
    @Autowired
    private IAlarmPointService alarmPointService;
    
    
    @ApiOperation(value = "上传巡检数据", notes = "上传巡检数据")
    @GetMapping(value = "/data")
    public CommonResponse updateProtalData(@RequestParam("date")String json) throws Exception {

//        protalDataRo.setBatchNo(UUID.randomUUID().toString());
//        Object result = remoteRuleServer.fireRule(protalDataRo, "weihuaguize/ProtalData");
//        return CommonResponseUtil.success("SUCCESS");
//        
    	ProtalDataRo date=	JSONObject.parseObject(json, ProtalDataRo.class);
            //对巡检异常存入表
            //判断点是不是存在报警 type  默认为"point"
      		long  pointid=  Long.valueOf(date.getPointID()+"");
      		
      		List<AlarmPoint> alarmPoint= alarmPointService.selectPointTypeAndPointId("3", pointid);	
      		if(alarmPoint!=null&&alarmPoint.size()>0){
      			//存在报警，判断当前状态是不是合格，合格则删除上次的报警			
      			if("1".equals(date.getExecuteStatus())){
      				//删除告警				
      				//alarmPointService.delete(alarmPoint.get(0).getId()+"");
      				alarmPointService.delete(alarmPoint.get(0));
      				
      			}
      		}else{
      			//不存在，判断当前状态是不是合格，不合格新增，合格不做任何操作
      			if(!"1".equals(date.getExecuteStatus())){
      				//增加告警
      				AlarmPoint	alarmPoint1=new AlarmPoint();
      				alarmPoint1.setPointId(pointid);
      				alarmPoint1.setPointType("3");
      				alarmPoint1.setUpdateDate(new Date());
      				alarmPoint1.setIsAlarm(1);//不合格    	
      				alarmPoint1.setContent(date.getName()+"巡检出现异常！");    
      				alarmPoint1.setCode(date.getCode());
      				alarmPoint1.setPointName(date.getName());
      				Map<String, Object> map = new HashMap<>();
      				map.put("position", date.getCoordinates());
      				map.put("storey", ""+date.getNum());
      				
      				alarmPoint1.setPointAttrs(JSON.toJSONString(map));
      				alarmPointService.save(alarmPoint1);
      				
      				
      			}
      		}
      		   List<AlarmPoint> list=   alarmPointService.findAll();
				
				WebsocketParam  param=new WebsocketParam("alarmPoint", JSON.toJSONString(list));
				
				 //client.sendMessage(param);
				 Properties props = PropertiesLoaderUtils.loadAllProperties("application.properties");
                 String url = (String) props.get("params.remoteWebsocketUrl") + "/generic/sendMessage";
                 HttpUtil.PostJson(url, JSON.toJSONString(param));
      		
      		 return CommonResponseUtil.success("SUCCESS");     		   
        
    }


    @ApiOperation(value = "上传隐患信息", notes = "上传隐患信息")
    @GetMapping(value = "/hiddentrouble")
    public CommonResponse hiddenTroubleInfo(@RequestParam("date")String json) throws Exception {
    	HiddenTroubleRo hiddenTroubleRo=	JSONObject.parseObject(json, HiddenTroubleRo.class);
        hiddenTroubleRo.setBatchNo(UUID.randomUUID().toString());
        Object result = remoteRuleServer.fireRule(hiddenTroubleRo, "weihuaguize/HiddenTrouble");
        return CommonResponseUtil.success("SUCCESS");
    }


    @ApiOperation(value = "触发风险因素等级变化规则", notes = "触发风险因素等级变化规则")
    @PostMapping(value = "/riskFactor")
    public CommonResponse riskFactor(@RequestBody RiskFactorBo riskFactorBo) throws Exception {
        iSpcRiskFactorService.firingRule(riskFactorBo);
        return CommonResponseUtil.success("SUCCESS");
    }
}
