package com.yeejoin.amos.spc.business.controller;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcCameraService;
import com.yeejoin.amos.spc.common.enums.CamerasEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.spc.dao.entity.SpcCameras;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcCamera")
@Api(tags = "摄像机api")
public class SpcCameraController extends BaseController {
    private static final Logger log = Logger.getLogger(SpcCameraController.class);

    @Autowired
    ISpcCameraService iCameraService;

    @ApiOperation(value = "保存摄像机", notes = "保存摄像机")
    @PostMapping(value = "/camera")
    public CommonResponse createCamera(@ApiParam(value = "摄像机", required = true) @RequestBody SpcCameras camera) {
        ReginParams reginParams = getSelectedOrgInfo();
        camera.setCreatorId(getUserId());
        camera.setOrgCode(getLoginOrgCode(reginParams));
        camera.setUpdateDate(new Date());
        try {
            iCameraService.saveCamera(camera);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("摄像机保存失败");
        }
    }

    @ApiOperation(value = "删除摄像机", notes = "删除摄像机")
    @DeleteMapping(value = "/camera/{ids}")
    public CommonResponse deleteCamera(@ApiParam(value = "摄像机", required = true) @PathVariable String ids) {
        List<Long> idList = Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        try {
            return CommonResponseUtil.success(iCameraService.deleteCameraById(idList));
        } catch (YeeException e) {
        	log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("摄像机删除失败");
        }
    }

    @ApiOperation(value = "分页查询摄像机信息", notes = "分页查询摄像机信息")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryCameraListByPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        try {
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
            ReginParams reginParams = getSelectedOrgInfo();
            DaoCriteria compDaoCriteria = new DaoCriteria();
            compDaoCriteria.setPropertyName("orgCode");
            compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
            compDaoCriteria.setValue(getLoginOrgCode(reginParams));
            criterias.add(compDaoCriteria);
            Page<SpcCameras> cameraList = iCameraService.queryCameraByPage(criterias, commonPageable);
            return CommonResponseUtil.success(cameraList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询摄像机信息失败");
        }
    }
	
	 /**
     * 获取类型
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取类型", notes = "获取类型")
    @GetMapping(value = "/types", produces = "application/json;charset=UTF-8")
    public CommonResponse getType() {
        return CommonResponseUtil.success(CamerasEnum.getEnumList());
    }
}
