package com.yeejoin.amos.spc.business.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcIdentificationMethodService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcIdentificationMethod;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcIdentificationMethod")
@Api(tags = "风险辨识方法api")
public class SpcIdentificationMethodController extends BaseController {
    private static final Logger log = Logger.getLogger(SpcIdentificationMethodController.class);

    @Autowired
    ISpcIdentificationMethodService iIdentificationMethodService;

    @ApiOperation(value = "新增风险辨识方法", notes = "新增风险辨识方法")
    @PostMapping(value = "/identificationMethod")
    public CommonResponse createIdentificationMethod(@ApiParam(value = "风险辨识方法", required = true) @RequestBody SpcIdentificationMethod identificationMethod) {
    	List<SpcIdentificationMethod> identifications = iIdentificationMethodService.queryIdentificationMethodByName(identificationMethod.getName());
    	if(identifications != null && identifications.size()>0) {
    		return CommonResponseUtil.failure("风险辨识方法已存在！");
    	}
        ReginParams reginParams = getSelectedOrgInfo();
        identificationMethod.setCreatorId(getUserId());
        identificationMethod.setOrgCode(getLoginOrgCode(reginParams));
        identificationMethod.setUpdateDate(new Date());
        try {
            iIdentificationMethodService.createIdentificationMethod(identificationMethod);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险辨识方法新增失败");
        }
    }

    @ApiOperation(value = "更新风险辨识方法", notes = "更新风险辨识方法")
    @PutMapping(value = "/identificationMethod")
    public CommonResponse updateIdentificationMethod(@ApiParam(value = "风险辨识方法", required = true) @RequestBody SpcIdentificationMethod identificationMethod) {
    	List<SpcIdentificationMethod> identifications = iIdentificationMethodService.queryIdentificationMethodByName(identificationMethod.getName());
    	if(null != identificationMethod.getId()) {//为编辑时过滤自己
    		identifications = identifications.stream().filter(e -> e.getId() != identificationMethod.getId()).collect(Collectors.toList());
    	}
    	if(identifications != null && identifications.size()>0) {
    		return CommonResponseUtil.failure("风险辨识方法已存在！");
    	}
        ReginParams reginParams = getSelectedOrgInfo();
        identificationMethod.setCreatorId(getUserId());
        identificationMethod.setOrgCode(getLoginOrgCode(reginParams));
        identificationMethod.setUpdateDate(new Date());
        try {
            iIdentificationMethodService.updateIdentificationMethod(identificationMethod);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险辨识方法更新失败");
        }
    }

    @ApiOperation(value = "删除风险辨识方法", notes = "删除风险辨识方法")
    @DeleteMapping(value = "/identificationMethod")
    public CommonResponse deleteIdentificationMethod(@ApiParam(value = "风险辨识方法", required = true) @RequestBody List<Long> ids) {
        try {
            iIdentificationMethodService.deleteIdenificationMethodById(ids);
            return CommonResponseUtil.success();
        } catch (YeeException e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险辨识方法删除失败");
        }
    }

    @ApiOperation(value = "分页查询风险辨识方法信息", notes = "分页查询风险辨识方法信息")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryIdentificationMethodListByPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        try {
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
//            ReginParams reginParams = getSelectedOrgInfo();//公共数据，不用按照org_code过滤，20191105
//            DaoCriteria compDaoCriteria = new DaoCriteria();
//            compDaoCriteria.setPropertyName("orgCode");
//            compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//            compDaoCriteria.setValue(getLoginOrgCode(reginParams));
//            criterias.add(compDaoCriteria);
            Page<SpcIdentificationMethod> identificationMethodList = iIdentificationMethodService.queryIdentificationMethodByPage(criterias, commonPageable);
            return CommonResponseUtil.success(identificationMethodList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询风险辨识方法信息失败");
        }
    }

    @ApiOperation(value = "查询风险辨识方法详情", notes = "查询风险辨识方法详情")
    @GetMapping(value = "/{id}", produces = "application/json;charset=UTF-8")
    public CommonResponse queryIdentificationMethodDetailById(@ApiParam(value = "风险辨识方法id", required = true) @PathVariable Long id) {
        try {
            SpcIdentificationMethod result = iIdentificationMethodService.queryIdentificationMethodDetailById(id);
            return CommonResponseUtil.success(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询风险辨识方法详情失败");
        }
    }

    @ApiOperation(value = "查询风险辨识方法列表", notes = "查询风险辨识方法列表")
    @GetMapping(value = "/list/all", produces = "application/json;charset=UTF-8")
    public CommonResponse queryAllIdentificationMethod() {
        try {
            List<DaoCriteria> criterias = new ArrayList<>();
//          ReginParams reginParams = getSelectedOrgInfo();//公共数据，不用按照org_code过滤，20191105
//			DaoCriteria compDaoCriteria = new DaoCriteria();
//			compDaoCriteria.setPropertyName("orgCode");
//			compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
//			compDaoCriteria.setValue(getLoginOrgCode(reginParams));
//			criterias.add(compDaoCriteria);
            List<SpcIdentificationMethod> identificationMethodList = iIdentificationMethodService.queryAllIdentificationMethod(criterias);
            return CommonResponseUtil.success(identificationMethodList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("查询风险辨识方法列表失败");
        }
    }
}
