package com.yeejoin.amos.spc.business.controller;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.PageParam;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMajorHazardInstallationService;
import com.yeejoin.amos.spc.dao.entity.SpcMajorHazardInstallation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcMajorHazardInstallation")
@Api(tags = "重大危险源api")
public class SpcMajorHazardInstallationController extends BaseController {

    private static final Logger log = Logger.getLogger(SpcMajorHazardInstallationController.class);

	@Autowired
	ISpcMajorHazardInstallationService iSpcMajorHazardInstallationService;

	@ApiOperation(value = "分页查询重大危险源信息", notes = "分页查询重大危险源信息")
	@PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
	public CommonResponse queryMajorHazardInstallatinByPage(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam<String, Object> pageParam) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
			String orgCode = getLoginOrgCode(reginParams);
			pageParam.put("orgCode", orgCode);
			return CommonResponseUtil.success(iSpcMajorHazardInstallationService.queryMajorHazardInstallationByPage(pageParam));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询重大危险源信息失败");
		}
	}
	
	@ApiOperation(value = "根据ID删除重大危险源", notes = "根据ID删除重大危险源")
	@DeleteMapping(value = "", produces = "application/json;charset=UTF-8")
	public CommonResponse deleteByIds(@ApiParam(value = "重大危险源ID", required = true) @RequestParam List<Long> ids) {
		try {
			iSpcMajorHazardInstallationService.delete(ids);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除重大危险源失败");
		}
	}
	
	@ApiOperation(value = "根据ID查询重大危险源信息", notes = "根据ID查询重大危险源信息")
	@GetMapping(value = "/{id}/detail", produces = "application/json;charset=UTF-8")
	public CommonResponse getDetailById(@ApiParam(value = "重大危险源ID", required = true) @PathVariable Long id) {
		try {
			return CommonResponseUtil.success(iSpcMajorHazardInstallationService.getMajorHazardInstallationDetailById(id));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询重大危险源失败");
		}
	}
	
	@ApiOperation(value = "保存重大危险源信息", notes = "保存重大危险源信息")
	@PostMapping(value = "", produces = "application/json;charset=UTF-8")
	public CommonResponse save(@RequestBody SpcMajorHazardInstallation majorHazardInstallation) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
			majorHazardInstallation.setCreatorId(getUserId());
			majorHazardInstallation.setOrgCode(getLoginOrgCode(reginParams));
			iSpcMajorHazardInstallationService.save(majorHazardInstallation);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("保存重大危险源失败");
		}
	}
}
