package com.yeejoin.amos.spc.business.controller;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMeasureContentService;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/spcMeasureContent")
@Api(tags = "控制措施内容api")
public class SpcMeasureContentController extends BaseController {

    private static final Logger log = Logger.getLogger(SpcMeasureContentController.class);
	
	@Autowired
	private ISpcMeasureContentService iSpcMeasureContentService;
	
	@ApiOperation(value = "删除控制措施内容", notes = "删除控制措施内容")
    @DeleteMapping(value = "/{id}")
	public CommonResponse deleteById(@PathVariable String id) {
		try {
			iSpcMeasureContentService.deleteMeasureContentById(Long.valueOf(id));
			return CommonResponseUtil.success();
		} catch (YeeException e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure(e.getMessage());
		} catch(Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除失败");
		}
	}
}
