package com.yeejoin.amos.spc.business.controller;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcTaskworkService;
import com.yeejoin.amos.spc.common.enums.DictTypeEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.spc.dao.entity.SpcTaskwork;
import com.yeejoin.amos.spc.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcTaskwork")
@Api(tags = "作业活动模块相关")
public class SpcTaskworkController extends BaseController {

    private static final Logger logger = Logger.getLogger(SpcTaskworkController.class);

    @Autowired
    private ISpcTaskworkService iSpcTaskworkService;
    
    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @ApiOperation(value = "添加", notes = "添加")
    @PostMapping(value = "/save")
    public CommonResponse save(@RequestBody SpcTaskwork spcTaskwork) {
    	ReginParams reginParams = getSelectedOrgInfo();
    	String orgCode = getLoginOrgCode(reginParams);
    	AgencyUserModel user = getUserInfo();
    	spcTaskwork.setCreatorId(user.getUserId());
    	spcTaskwork.setCreateUserName(user.getUserName());
    	spcTaskwork.setOrgCode(orgCode);
    	spcTaskwork.setApplyUserId(user.getUserId());
        try {
            return iSpcTaskworkService.save(spcTaskwork);
        } catch (YeeException e) {
            logger.error("添加异常", e);
            return CommonResponseUtil.failure(e.getMessage());
        } catch (Exception e) {
            logger.error("添加异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }

    }

    @ApiOperation(value = "编辑", notes = "编辑")
    @PostMapping(value = "/update")
    public CommonResponse update(@RequestBody SpcTaskwork spcTaskwork) {
        try {
            return iSpcTaskworkService.update(spcTaskwork);
        } catch (Exception e) {
            logger.error("编辑异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "列表", notes = "列表")
    @PostMapping(value = "/list")
    public CommonResponse list(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                               @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
            DaoCriteria compDaoCriteria = new DaoCriteria();
            compDaoCriteria.setPropertyName("orgCode");
            compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
            compDaoCriteria.setValue(getLoginOrgCode(reginParams));
            criterias.add(compDaoCriteria);
            return iSpcTaskworkService.list(criterias, commonPageable);
        } catch (Exception e) {
            logger.error("列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }
    
    @ApiOperation(value = "不分页列表", notes = "列表")
    @PostMapping(value = "/list-all")
    public CommonResponse listAll(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests) {
        try {
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
            return CommonResponseUtil.success(iSpcTaskworkService.listAll(criterias));
        } catch (Exception e) {
            logger.error("列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "删除作业活动", notes = "删除作业活动")
    @DeleteMapping(value = "/{taskworkIds}")
    public CommonResponse delete(@ApiParam(value = "作业活动ID") @PathVariable String taskworkIds) {
    	try {
    		String[] arry = taskworkIds.split(",");
    		List<Long> idList = new ArrayList<Long>();
    		for(String id : arry){
    			idList.add(Long.parseLong(id));
    		}
    		iSpcTaskworkService.delete(idList);
    	} catch (YeeException e) {
    		logger.error(e.getMessage());
    		return CommonResponseUtil.failure(e.getMessage());
		}
    	return CommonResponseUtil.success();
    }
    
    @ApiOperation(value = "删除作业活动步骤", notes = "删除作业活动步骤")
    @DeleteMapping(value = "/content/{contentId}")
    public CommonResponse taskworkStepDelete(@ApiParam(value = "作业活动步骤ID") @PathVariable Long contentId) {
    	try {
			iSpcTaskworkService.deleteTaskworkContent(contentId);
		} catch (YeeException e) {
			logger.error(e.getMessage());
			return CommonResponseUtil.failure(e.getMessage());
		}
    	return CommonResponseUtil.success(true);
    }
    
    /**
     * 获取作业活动类别
     *
     * @return
     */
    @ApiOperation(httpMethod = "GET", value = "获取作业活动类别", notes = "获取作业活动类别")
    @GetMapping(value = "/types", produces = "application/json;charset=UTF-8")
    public CommonResponse getTypes() {
        return CommonResponseUtil.success(remoteSecurityService.getDictValues(DictTypeEnum.TASKWORKTYPE.getCode()));
    }
    
    @ApiOperation(value = "获取作业活动详情", notes = "获取作业活动详情")
    @GetMapping(value = "/{taskworkId}/detail")
    public CommonResponse getTaskworkDetail(@ApiParam(value = "作业活动ID") @PathVariable Long taskworkId) {
    	try {
    		SpcTaskwork taskwork = iSpcTaskworkService.getTaskworkDetail(taskworkId);
    		return CommonResponseUtil.success(taskwork);
    	} catch (Exception e) {
    		logger.error(e.getMessage());
    		return CommonResponseUtil.failure(e.getMessage());
    	}
    }
    
    @ApiOperation(value = "获取作业活动步骤详情", notes = "获取作业活动步骤详情")
    @GetMapping(value = "/taskworkContentDetail/{id}")
    public CommonResponse getTaskworkContentDetail(@ApiParam(value = "作业活动步骤id") @PathVariable("id") Long taskworkContentId) {
    	try {
    		SpcTaskwork taskwork = iSpcTaskworkService.getTaskworkContentIdDetail(taskworkContentId);
    		return CommonResponseUtil.success(taskwork);
    	} catch (Exception e) {
    		logger.error(e.getMessage());
    		return CommonResponseUtil.failure(e.getMessage());
    	}
    }
}
