package com.yeejoin.amos.spc.business.controller;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.bank.service.IDynamicRingDataService;
import com.yeejoin.amos.bank.service.IEquipmentService;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.dao.mapper.View3DMapper;
import com.yeejoin.amos.spc.business.param.PageParam;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEquipmentService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMajorHazardInstallationService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskSourceService;
import com.yeejoin.amos.spc.business.service.intfc.IView3DService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.spc.core.util.StringUtil;
import com.yeejoin.amos.spc.dao.entity.SpcEquipment;
import com.yeejoin.amos.spc.dao.entity.SpcMajorHazardInstallation;
import com.yeejoin.amos.spc.dao.entity.SpcRiskSource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 
 * <pre>
 * 界面视图Controller
 * </pre>
 *
 */
@RestController
@RequestMapping(value = "/view3d")
@Api(value = "view3d", tags = { "三维视图API" })
public class View3DController extends BaseController {

	private static final Logger logger = Logger.getLogger(View3DController.class);

	@Autowired
	private IView3DService view3DService;

	@Autowired
	private View3DMapper view3DMapper;

	@Autowired
	private ISpcRiskSourceService riskSourceService;
	
	@Autowired
	private ISpcMajorHazardInstallationService iSpcMajorHazardInstallationService;

	@Autowired
	ISpcEquipmentService iEquipmentService;
	
	@Autowired
	private IDynamicRingDataService iDynamicRingDataService;
	
	@Autowired
	private  IEquipmentService iequipmentService;

	/**
	 * 
	 * <pre>
	 * 初始化三维视图节点
	 * </pre>
	 *
	 * @param type
	 * @return
	 */
	@GetMapping(value = "/initViewNode", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "初始化三维视图节点", notes = "初始化三维视图节点")
	public CommonResponse initViewNode(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false) String type,
			@ApiParam(value = "组织code", required = false) @RequestParam(required = false) String orgCode) {
		if (StringUtil.isNotEmpty(type) && StringUtil.isNotEmpty(orgCode)) {
			//动环数据
			String token = getToken();
			if(type.equals("dynamicRingData")) {
				ArrayList<Node3DVoResponse> query3dData = iDynamicRingDataService.query3dData(token,orgCode);
				return CommonResponseUtil.success(query3dData);
			}else if(type.equals("impEquipment")){//设备
				return CommonResponseUtil.success(iequipmentService.queryEqui3dData(orgCode));
			}
			

			return CommonResponseUtil.success(view3DService.findViewDataByType(type, orgCode));


		}
		return CommonResponseUtil.failure();
	}

	/**
	 * 获取风险详情
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/riskSourceDetails", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "获取风险详情", notes = "获取风险详情")
	public CommonResponse getRiskSourceDetailsById(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false) Long id) {
		if (StringUtil.isNotEmpty(id)) {
			return CommonResponseUtil.success(view3DService.getRiskSourceDetailsById(id));
		}
		return CommonResponseUtil.failure();
	}
	
	/**
	 * 获取点详情
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/pointDetails", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "获取点详情", notes = "获取点详情")
	public CommonResponse pointDetails(
			@ApiParam(value = "id", required = false) @RequestParam(required = false) Long id) {
		if (StringUtil.isNotEmpty(id)) {
			return CommonResponseUtil.success(view3DService.getPointDetailsById(id));

		}
		return CommonResponseUtil.failure();
	}

	/**
	 * 获取设备详情
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/euqipmentDetails", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "获取设备详情", notes = "获取设备详情")
	public CommonResponse getEquipDetailsById(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false) Long id) {
		if (StringUtil.isNotEmpty(id)) {
			return CommonResponseUtil.success(view3DService.getEquipDetailsById(id));

		}
		return CommonResponseUtil.failure();
	}

	/**
	 * 获取隐患详情
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/dangerDetails", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "获取隐患详情", notes = "获取隐患详情")
	public CommonResponse getDangerDetailsById(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false) Long id) {
		if (StringUtil.isNotEmpty(id)) {
			return CommonResponseUtil.success(view3DService.getDangerDetailsById(id));

		}
		return CommonResponseUtil.failure();
	}

	/**
	 * 根据类型查询资源信息
	 * 
	 * @param type
	 * @param queryRequests
	 * @param commonPageable
	 * @return
	 */
	@ApiOperation(value = "根据类型查询资源信息", notes = "根据类型查询资源信息")
	@PostMapping(value = "/resourceData", produces = "application/json;charset=UTF-8")
	public CommonResponse queryEquipmentListByPage(
			@ApiParam(value = "资源类型", required = false) @RequestParam(required = false) String type,
			@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
			List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
			DaoCriteria compDaoCriteria = new DaoCriteria();
			compDaoCriteria.setPropertyName("orgCode");
			compDaoCriteria.setOperator(QueryOperatorEnum.EQUAL.getName());
			compDaoCriteria.setValue(getLoginOrgCode(reginParams));
			criterias.add(compDaoCriteria);
			if ("equipment".equals(type)) {//设备
				Page<SpcEquipment> equipmentList = iEquipmentService.queryEquipmentByPage(criterias, commonPageable);
				List<SpcEquipment> list = equipmentList.getContent();
				if (!CollectionUtils.isEmpty(list) && !ObjectUtils.isEmpty(type)) {
					list.forEach(e -> {
						e.setMarkType(type);
					});
				}
				return CommonResponseUtil.success(equipmentList);
			} else if ("majorHazard".equals(type)) {// 重大危险源
				PageParam<String, Object> param = new PageParam<>();
				if (queryRequests != null && !queryRequests.isEmpty()) {
		            for (CommonRequest query : queryRequests) {
		            	param.put(query.getType(), query.getValue());
		            }
				}
				param.setPageNumber(commonPageable.getPageNumber());
				param.setPageSize(commonPageable.getPageSize());
				param.setOffset(commonPageable.getOffset());
				param.put("pageSize", param.getPageSize());
				param.put("offset", param.getOffset());
				Page<List<SpcMajorHazardInstallation>> spcMajorHazardList = iSpcMajorHazardInstallationService.queryMajorHazardInstallationByPage(param);
				List<List<SpcMajorHazardInstallation>> list = spcMajorHazardList.getContent();
				if (!CollectionUtils.isEmpty(list) && !ObjectUtils.isEmpty(type)) {
					for (int i = 0; i < list.size(); i++) {
						((SpcMajorHazardInstallation)list.get(i)).setMarkType(type);
					}
				}
				return CommonResponseUtil.success(spcMajorHazardList);
			} else {//风险源
				Page<SpcRiskSource> spcRiskSourceList = riskSourceService.querySpcRiskSourceByPage(criterias,
						commonPageable);
				List<SpcRiskSource> list = spcRiskSourceList.getContent();
				if (!CollectionUtils.isEmpty(list) && !ObjectUtils.isEmpty(type)) {
					list.forEach(e -> {
						e.setMarkType(type);
					});
				}
				return CommonResponseUtil.success(spcRiskSourceList);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询信息失败");
		}
	}

	@GetMapping(value = "/risksource3d", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "风险点", notes = "风险点")
	public CommonResponse queryForEquipRiskSource() {
		return CommonResponseUtil.success(view3DMapper.queryForEquipRiskSource());
	}

	@GetMapping(value = "/equipmentinfo", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "设备信息", notes = "设备信息")
	public CommonResponse queryForEquipPosition() {
		return CommonResponseUtil.success(view3DMapper.queryForEquipPosition());
	}

	@GetMapping(value = "/videomonitorinfo3d", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "监控设备", notes = "监控设备")
	public CommonResponse queryForVideomonitorinfo3d() {
		return CommonResponseUtil.success(view3DMapper.queryForVideomonitorinfo3d());
	}

	
	/**
	 *  巡点查询
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/getpointlist", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "巡点查询", notes = "巡点查询")
	public CommonResponse getpointlist(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false) String floor,@RequestParam(required = false) String code) {
		
         try {
 			return CommonResponseUtil.success(view3DMapper.getpointlist( floor, code));

		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			return CommonResponseUtil.failure();

		}
		
	}
	
	@GetMapping(value = "/updatepoint", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "修改巡点点", notes = "修改巡点点")
	public CommonResponse updatepoint(
			@ApiParam(value = "节点类型", required = false) @RequestParam(required = false)String coordinates,@RequestParam(required = false)String id) {
		
			
			  try {
				  view3DMapper.updatepoint( coordinates, id);
					return CommonResponseUtil.success();
			} catch (Exception e) {
				return CommonResponseUtil.failure();
			}
		
	}
	
	
}
