package com.yeejoin.amos.spc.business.dao.repository;

import com.yeejoin.amos.spc.dao.entity.SpcEquipmentCameraBind;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

;

@Repository("iSpcEquipmentCameraBindDao")
public interface ISpcEquipmentCameraBindDao extends BaseDao<SpcEquipmentCameraBind, Long> {

    int countByEquipmentId(Long id);

    @Query(value = "select count(1) from spc_equipment_camera_bind where equipment_id = ?1 and camera_id = ?2", nativeQuery = true)
    int countByEquipmentIdAndCameraId(Long equipId, Long cameraId);

    @Modifying
    @Transactional
    @Query(value = "delete from spc_equipment_camera_bind where equipment_id = ?1 and camera_id in (?2)", nativeQuery = true)
    void deleteByEquipmentIdAndCameraIds(Long equipmentId, List<Long> cameraIds);

    @Query(value = "select * from spc_equipment_camera_bind where camera_id = ?1", nativeQuery = true)
    SpcEquipmentCameraBind findByCameraId(Long id);
}
