package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.spc.dao.entity.SpcIdentificationMethod;

@Repository("iIdentificationMethodDao")
public interface ISpcIdentificationMethodDao extends BaseDao<SpcIdentificationMethod, Long> {

	@Modifying
	@Transactional
	@Query(value="delete from spc_identification_method where id in ?1", nativeQuery = true)
	void deleteByIds(List<Long> ids);

	List<SpcIdentificationMethod> findByName(String name);

}
