package com.yeejoin.amos.spc.business.dao.repository;

import com.yeejoin.amos.spc.dao.entity.SpcRiskFactor;
import com.yeejoin.amos.spc.dao.entity.SpcRiskSource;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iSpcRiskFactorDao")
public interface ISpcRiskFactorDao extends BaseDao<SpcRiskFactor, Long> {

    public int countByRiskSourceId(Long riskSourceId);

    int countByRiskSourceIdAndName(Long riskSourceId, String name);
    
    SpcRiskFactor findByRiskSourceIdAndName(Long riskSourceId, String name);
    
    //SpcRiskFactor findById(Long id);

    @Modifying
    @Transactional
    @Query(value = "delete from spc_risk_factors where id in (?1)", nativeQuery = true)
    void deleteBatchByIds(List<Long> ids);

    @Query(value = "select * from spc_risk_factors where id in (?1) and status = '0'", nativeQuery = true)
    List<SpcRiskFactor> findByIds(List<Long> ids);

    @Query(value = "select * from spc_risk_factors where risk_source_id = ?1", nativeQuery = true)
    List<SpcRiskFactor> findByRiskSourceId(Long riskSourceId);


    @Query(value = "SELECT * FROM spc_risk_factors sf WHERE EXISTS(select 1 from spc_risk_source ss where ss.parent_id = ?1 and ss.id = sf.risk_source_id)", nativeQuery = true)
    List<SpcRiskFactor> findListForLocationRisk(Long locationRiskId);



    @Query(value = "SELECT " +
            " * " +
            "FROM " +
            " spc_risk_factors sf " +
            "WHERE " +
            " EXISTS ( " +
            "  SELECT " +
            "   1 " +
            "  FROM " +
            "   spc_risk_source ss " +
            "  WHERE " +
            "   ss.parent_id IN ( " +
            "    SELECT " +
            "     ls.id " +
            "    FROM " +
            "     spc_risk_source ls " +
            "    WHERE " +
            "     ls.parent_id = ( " +
            "      SELECT " +
            "       ss.parent_id " +
            "      FROM " +
            "       spc_risk_source ss " +
            "      WHERE " +
            "       ss.id = ?1 " +
            "     ) " +
            "   ) " +
            "  AND ss.id = sf.risk_source_id " +
            " )", nativeQuery = true)
    List<SpcRiskFactor> findListForAreaRisk(Long locationRiskId);
    
    @Query(value = "select * from spc_risk_factors where type = ?1 and control_object_id = ?2", nativeQuery = true)
    List<SpcRiskFactor> findByControlObjectIdAndType(String type, Long controlObjectId);
    
    @Query(value = "select count(1) from spc_risk_factors where type = ?1 and control_object_id in ?2", nativeQuery = true)
    int countByControlObjectIdsAndType(String type, List<Long> controlObjectId);

	public SpcRiskFactor findByEvaluateId(Long instanceId);

	@Query(value = "SELECT COUNT(1) FROM spc_risk_factors WHERE FIND_IN_SET(?1, identification_method_ids)", nativeQuery = true)
	public int countByIdentificationMethodId(Long id);

	@Query(value = "SELECT COUNT(1) FROM spc_risk_factors WHERE level_id = ?1", nativeQuery = true)
	public int countByRiskLevelId(String id);

	@Query(value = "SELECT COUNT(1) FROM spc_risk_factors WHERE FIND_IN_SET(?1, aftermath_ids)", nativeQuery = true)
	public int countByAftermathId(String id);

}
