package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import javax.transaction.Transactional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.spc.dao.entity.SpcTaskworkMeasure;

@Repository("iSpcTaskworkMeasurDao")
public interface ISpcTaskworkMeasureDao extends BaseDao<SpcTaskworkMeasure, Long> {

	@Query(value = "select a.id from spc_taskwork_measures a,spc_risk_factors_cm b where a.risk_factors_cm_id = b.id and b.risk_factors_id = ?1", nativeQuery = true)
	List<Long> findExistFactorMeasure(Long id);

	@Modifying
	@Transactional
	@Query(value = "delete from spc_taskwork_measures where id in (?1)", nativeQuery = true)
	void deleteByIds(List<Long> measureIdList);

	@Query(value = "select count(1) from spc_taskwork_measures where measures_content_id = ?1", nativeQuery = true)
	Long countByMeasureId(Long id);
}
