package com.yeejoin.amos.spc.business.service.impl;

import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import com.yeejoin.amos.spc.business.dao.mapper.ContingencyOriginalMapper;
import com.yeejoin.amos.spc.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.spc.business.service.intfc.IContingencyOriginalDataService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.dao.entity.ContingencyOriginalData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class ContingencyOriginalServiceImpl extends GenericManagerImpl<ContingencyOriginalData, String> implements IContingencyOriginalDataService
{
	IContingencyOriginalDataDao repository;

	@Autowired
	private ContingencyOriginalMapper contingencyOriginalMapper;

	public ContingencyOriginalServiceImpl(IContingencyOriginalDataDao repository)
	{
		super(repository);
		this.repository = repository;
	}




	public ContingencyOriginalData queryByBatchNo(String batchNo)
	{
		return this.repository.findByBatchNo(batchNo);
	}


	public List<ContingencyOriginalData> queryForContingencyRecord(String contingencyName , String equipmentId, Date createTime)
	{
		List<ContingencyOriginalData> returnList = new ArrayList<>();


		return returnList;
	}


	public Page queryForPage(String  contingencyName, String equipmentId, String  createTime, CommonPageable pageable)
	{
		Long total = contingencyOriginalMapper.queryCountForPage(equipmentId,createTime);
		List<Map> content = contingencyOriginalMapper.queryForPage(equipmentId,createTime,pageable.getOffset(),pageable.getPageSize());
		Page result = new PageImpl(content,pageable,total);
		return result;
	}



}
