package com.yeejoin.amos.spc.business.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcHazardSourceClassifyDao;
import com.yeejoin.amos.spc.business.service.intfc.IHazardSourceClassifyService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcHazardSourceClassify;

@Service("hazardSourceClassifyService")
public class HazardSourceClassifyServiceImpl implements IHazardSourceClassifyService {

	@Autowired 
	private ISpcHazardSourceClassifyDao spcHazardSourceClassifyDao;
	@Override
	public void addEntry(SpcHazardSourceClassify entry) {
		spcHazardSourceClassifyDao.save(entry);
	}

	@Override
	public void delEntryById(String[] param) {
		spcHazardSourceClassifyDao.deleteBatchByIds(param);
	}

	@Override
	public Page<SpcHazardSourceClassify> queryEntryByCondition(List<DaoCriteria> criterias,
			CommonPageable pageable) {
		BaseQuerySpecification<SpcHazardSourceClassify> specification = new BaseQuerySpecification<>(criterias);
		Sort sort = new Sort(Sort.Direction.DESC,"id");
		pageable.setSort(sort);
		return spcHazardSourceClassifyDao.findAll(specification, pageable);
	}

	@Override
	public List<SpcHazardSourceClassify> findByName(String name) {
		return spcHazardSourceClassifyDao.findByName(name);
		
	}


}
