package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.google.common.base.Joiner;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcAftermathDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorDao;
import com.yeejoin.amos.spc.business.service.intfc.ISpcAftermathService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcAftermath;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcAftermathService")
public class SpcAftermathServiceImpl implements ISpcAftermathService {


    @Autowired
    private ISpcAftermathDao spcAftermathDao;
    
    @Autowired
    private ISpcRiskFactorDao iSpcRiskFactorDao;
    
    @Autowired
    private ISpcAftermathDao iSpcAftermathDao;

    @Override
    public Page<SpcAftermath> queryEntryByCondition(List<DaoCriteria> criterias, CommonPageable pageable) {
        BaseQuerySpecification<SpcAftermath> specification = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
		pageable.setSort(sort);
        return spcAftermathDao.findAll(specification, pageable);
    }

    @Override
    public void addEntry(SpcAftermath entry) {
        spcAftermathDao.save(entry);
    }

    @Override
    public void delEntryById(String[] ids) {
    	List<String> removedIds = new ArrayList<>();
    	List<String> aftermathNames = new ArrayList<>();
    	for (String id : ids) {
    		int count = iSpcRiskFactorDao.countByAftermathId(id);
    		if (count > 0) {
    			removedIds.add(id);
    			if (null != iSpcAftermathDao.findById(Long.valueOf(id)).get()) {
    				aftermathNames.add(iSpcAftermathDao.findById(Long.valueOf(id)).get().getName());
    			}
    		}
    	}
    	List<String> newArr = new ArrayList<>(Arrays.asList(ids));
    	newArr.removeAll(removedIds);
    	if (newArr.size() > 0) {
    		spcAftermathDao.deleteBatchByIds(newArr);
    	}
        if (removedIds.size() > 0) {
        	throw new YeeException("后果【" + Joiner.on(",").join(aftermathNames) + "】正在使用，删除失败！");
        }
    }

	@Override
	public List<SpcAftermath> queryAftermathByName(String name) {
		return spcAftermathDao.findByName(name);
	}

}
