package com.yeejoin.amos.spc.business.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEvaluateModelDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEvaluateNormDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskLevelDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEvaluateModelService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcEvaluateModel;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcEvaluateModelService")
public class SpcEvaluateModelServiceImpl implements ISpcEvaluateModelService {

    @Autowired
    private ISpcEvaluateModelDao iSpcEvaluateModelDao;

    @Autowired
    private ISpcEvaluateNormDao iSpcEvaluateNormDao;

    @Autowired
    private ISpcRiskLevelDao iSpcRiskLevelDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public SpcEvaluateModel save(SpcEvaluateModel spcEvaluateModel) {
        // TODO Auto-generated method stub
        return iSpcEvaluateModelDao.save(spcEvaluateModel);
    }

    @Override
    public void delete(String[] ids) {
        if (ids.length > 0) {
            for (String id : ids) {
                Long evaluateModelId = Long.valueOf(id);
                if (iSpcEvaluateModelDao.existsById(evaluateModelId)) {
                    if (iSpcEvaluateNormDao.countByEvaluateModelId(evaluateModelId) > 0 ||
                            iSpcRiskLevelDao.countByEvaluateModelId(evaluateModelId) > 0) {
                        throw new YeeException("该数据正在使用，请核实后再进行删除！");
                    } else {
                        iSpcEvaluateModelDao.deleteById(evaluateModelId);
                    }
                }
            }
        }
    }

    @Override
    public Page<SpcEvaluateModel> list(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcEvaluateModel> spec = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcEvaluateModel> page = iSpcEvaluateModelDao.findAll(spec, commonPageable);
        List<SpcEvaluateModel> list = page.getContent();
        if (!CollectionUtils.isEmpty(list)) {
            List<String> userIds = Lists.transform(list, SpcEvaluateModel::getCreatorId);
            Set<String> userIdSets = Sets.newHashSet(userIds);
            userIdSets.remove(null);
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            list.forEach(e -> {
                AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
                if (AgencyUserModel != null) {
                    e.setCreateUserName(AgencyUserModel.getRealName());
                }
            });
        }
        return page;
    }

    @Override
    public List<SpcEvaluateModel> listAll() {
        return iSpcEvaluateModelDao.findAll();
    }

	@Override
	public List<SpcEvaluateModel> queryEvaluateModelByName(String name) {
		return iSpcEvaluateModelDao.findByName(name);
	}
}
