package com.yeejoin.amos.spc.business.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEvaluateNormDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEvaluateNormService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcEvaluateNorm;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcEvaluateNormService")
public class SpcEvaluateNormServiceImpl implements ISpcEvaluateNormService {

    @Autowired
    private ISpcEvaluateNormDao iSpcEvaluateNormDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public SpcEvaluateNorm save(SpcEvaluateNorm evaluateNorm) {
        // TODO Auto-generated method stub
        return iSpcEvaluateNormDao.save(evaluateNorm);
    }

    @Override
    public void delete(String[] ids) {
        if (ids.length > 0) {
            for (String id : ids) {
                Long evaluateNormId = Long.valueOf(id);
                if (iSpcEvaluateNormDao.existsById(evaluateNormId)) {
                    iSpcEvaluateNormDao.deleteById(evaluateNormId);
                }
            }
        } else {
            throw new YeeException("请选择需要删除的数据！");
        }
    }

    @Override
    public Page<SpcEvaluateNorm> list(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcEvaluateNorm> spec = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcEvaluateNorm> page = iSpcEvaluateNormDao.findAll(spec, commonPageable);
        List<SpcEvaluateNorm> list = page.getContent();
        if (!CollectionUtils.isEmpty(list)) {
            List<String> userIds = Lists.transform(list, SpcEvaluateNorm::getCreatorId);
            Set<String> userIdSets = Sets.newHashSet(userIds);
            userIdSets.remove(null);
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            list.forEach(e -> {
                AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
                if (AgencyUserModel != null) {
                    e.setCreateUserName(AgencyUserModel.getRealName());
                }
            });
        }
        return page;
    }

	@Override
	public List<SpcEvaluateNorm> queryEvaluateNormByNameAndEvaluateId(String name, Long evaluateModelId) {
		return iSpcEvaluateNormDao.findByNameAndEvaluateModelId(name,evaluateModelId);
	}
}
