package com.yeejoin.amos.spc.business.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.spc.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.spc.business.dao.mapper.PointInputItemMapper;
import com.yeejoin.amos.spc.business.dao.repository.ISpcMeasuresContentDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcTaskworkMeasureDao;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMeasureContentService;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("iSpcMeasureContentService")
public class SpcMeasureContentServiceImpl implements ISpcMeasureContentService {
	
	@Autowired
	private ISpcMeasuresContentDao iSpcMeasuresContentDao;
	
	@Autowired
	private ISpcTaskworkMeasureDao iSpcTaskworkMeasureDao;
	
	@Autowired
	private PointInputItemMapper pointInputItemMapper;
	
	@Autowired
	private InputItemMapper inputItemMapper;
	
	@Override
	public void deleteMeasureContentById(Long id) {
		// 1.spc_taskwork_measure中不存在
		Long count1 = iSpcTaskworkMeasureDao.countByMeasureId(id);
		// 2.p_input_item,p_point_inputitem不存在
		Long count2 = pointInputItemMapper.countByMeasureContentId(id);
		if (count1 + count2 > 0) {
			throw new YeeException("控制措施内容正在使用，删除失败！");
		} else if (null != iSpcMeasuresContentDao.findById(id).get()) {
			iSpcMeasuresContentDao.deleteById(id);
			inputItemMapper.deleteInputItemByMeasureContentId(String.valueOf(id));
		}
	}

}
