package com.yeejoin.amos.spc.core.util;

import java.util.List;

import org.springframework.util.CollectionUtils;

import com.yeejoin.amos.spc.business.param.CommonPageInfoParam;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;

public class CommonPageParamUtil {

	public static CommonPageInfoParam fillCommonPageInfoParam(List<CommonRequest> queryRequests,
			CommonPageable commonPageable) {
		CommonPageInfoParam param = new CommonPageInfoParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("name".equals(name)) {
				param.setName(toString(queryRequests.get(i).getValue()));
			} else if ("id".equals(name)) {
				param.setId(toLong(queryRequests.get(i).getValue()));
			} else if ("riskSourceId".equals(name)) {
				param.setRiskSourceId(toLong(queryRequests.get(i).getValue()));
			} else if ("riskFactorName".equals(name)) {
				param.setRiskFactorName(toString(queryRequests.get(i).getValue()));
			} else if ("controlModelName".equals(name)) {
				param.setControlModelName(toString(queryRequests.get(i).getValue()));
			}else if ("type".equals(name)) {
				param.setType(toString(queryRequests.get(i).getValue()));
			}
		}
		if (commonPageable != null) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		return param;
	}

	private static String toString(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return value.toString();
		}
	}

	private static Long toLong(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return Long.parseLong(value.toString());
		}
	}

	public static Object getValue(String propertyName, List<CommonRequest> queryRequests) {
		Object value = null;
		if (!CollectionUtils.isEmpty(queryRequests)) {
			for (CommonRequest request : queryRequests)
				if (propertyName.equals(request.getName()))
					value = request.getValue();
		}
		return value;
	}

}
