package com.yeejoin.amos.bank.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 告警点类型
 *
 */
public enum AlarmPointTypeEnum {
	设备("设备", "1"),
	动环("动环", "2"),
	巡检("巡检", "3"),
	通道("通道", "4"),
	虚拟设备("虚拟设备", "5"),
	火探("火探", "6");
	
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    AlarmPointTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static AlarmPointTypeEnum getEnum(String code) {
        AlarmPointTypeEnum instance = null;
        for (AlarmPointTypeEnum type : AlarmPointTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumName(String code) {
        String name = "";
        for (AlarmPointTypeEnum type : AlarmPointTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }

        return name;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (AlarmPointTypeEnum e : AlarmPointTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
