package com.yeejoin.amos.bank.common.enums;

/**
 * 
 * <pre>
 * 巡检状态枚举
 * </pre>
 *
 * @author amos
 * @version $Id: CheckStateEnum.java, v 0.1 2018年12月11日 下午6:27:15 amos Exp $
 */
public enum CheckStateEnum{

	UNPLAN("未纳入巡检计划", 0, "", "unplanned"),
	QUALIFIED("合格", 1, "", "pass"),   //巡检点合格
	UNQUALIFIED("不合格", 2, "#DF7400", "offGrade"),   //巡检点不合格
	MISSPATROL("漏检", 3, "#FF0000", "miss");  //巡检点漏检
//	normal NORMAL("正常")

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	
	/**
	 * 状态颜色
	 */
	private String color;
	/**
	 * 三维点上显示图标名
	 */
	private String showInfo;

	// 构造方法
	private CheckStateEnum(String name, int value, String color, String showInfo) {
		this.name = name;
		this.value = value;
		this.color = color;
		this.showInfo = showInfo;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引名称
	 * </pre>
	 *
	 * @param value
	 * @return
	 */
	public static String getName(int value) {
		for (CheckStateEnum c : CheckStateEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param value
	 * @return
	 */
	public static CheckStateEnum getEnum(int value) {
		for (CheckStateEnum c : CheckStateEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param name
	 * @return
	 */
	public static CheckStateEnum getEnum(String name) {
		for (CheckStateEnum c : CheckStateEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}

	/**
	 * Getter method for property <tt>name</tt>.
	 * 
	 * @return property value of name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Setter method for property <tt>name</tt>.
	 * 
	 * @param name
	 *            value to be assigned to property name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Getter method for property <tt>value</tt>.
	 * 
	 * @return property value of value
	 */
	public int getValue() {
		return value;
	}

	/**
	 * Setter method for property <tt>value</tt>.
	 * 
	 * @param value
	 *            value to be assigned to property value
	 */
	public void setValue(int value) {
		this.value = value;
	}

	public String getColor()
	{
		return color;
	}

	public void setColor(String color)
	{
		this.color = color;
	}

	public String getShowInfo()
	{
		return showInfo;
	}

	public void setShowInfo(String showInfo)
	{
		this.showInfo = showInfo;
	}

}
