package com.yeejoin.amos.bank.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 支付交易
 */
public enum PaymentEnum {
//	累计流入交易("累计流入交易", "LJLRJY"),
//	累计流出交易("累计流出交易", "LJLCJY"),
//	累计流入交易金额("累计流入交易金额", "LJLRJYJE"),
//    累计流出交易金额("累计流出交易金额", "LJLCJYJE"),
    
    流入笔数("流入笔数", "LRBS"),
    流出笔数("流出笔数", "LCBS"),
    流入金额("流入金额", "LRJE"),
    流出金额("流出金额", "LCJE");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    PaymentEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static PaymentEnum getEnum(String code) {
        PaymentEnum instance = null;
        for (PaymentEnum type : PaymentEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumName(String code) {
        String name = "";
        for (PaymentEnum type : PaymentEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }

        return name;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (PaymentEnum e : PaymentEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }
    
    public static List<String> getEnumCodesList() {
        List<String> list = new ArrayList<>();
        for (PaymentEnum e : PaymentEnum.values()) {
            list.add(e.getCode().trim());
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
