package com.yeejoin.amos.bank.common.enums;

/**
 * 
 * <pre>
 * 3D视图节点类型
 * </pre>
 *
 * @author amos
 * @version $Id: View3DNodeType.java, v 0.1 2018年12月3日 上午11:56:55 amos Exp $
 */
public enum View3DNodeType {

	PATROL("patrol", 1),   //巡检点
	RISK("risk", 2),   //风险点
	DATA("data", 3),  //数据点
	VIDEO("video", 4),  //视频点
	CROOM("croom", 5),  //控制室
	PERSON("person", 6), //人员点
	TRAJECTORY("trajectory", 7); //轨迹点

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;

	// 构造方法
	private View3DNodeType(String name, int value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引名称
	 * </pre>
	 *
	 * @param value
	 * @return
	 */
	public static String getName(int value) {
		for (View3DNodeType c : View3DNodeType.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param value
	 * @return
	 */
	public static View3DNodeType getEnum(int value) {
		for (View3DNodeType c : View3DNodeType.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param name
	 * @return
	 */
	public static View3DNodeType getEnum(String name) {
		for (View3DNodeType c : View3DNodeType.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}

	/**
	 * Getter method for property <tt>name</tt>.
	 * 
	 * @return property value of name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Setter method for property <tt>name</tt>.
	 * 
	 * @param name
	 *            value to be assigned to property name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Getter method for property <tt>value</tt>.
	 * 
	 * @return property value of value
	 */
	public int getValue() {
		return value;
	}

	/**
	 * Setter method for property <tt>value</tt>.
	 * 
	 * @param value
	 *            value to be assigned to property value
	 */
	public void setValue(int value) {
		this.value = value;
	}

}
