package com.yeejoin.amos.bank.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="spc_alarm")
public class Alarm {

	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "id",nullable=false,unique=true)
	private Long id;
	@Column(name = "source_id")//'设备编号',
	private  String  sourceId;
	@Column(name = "alarm_level")
	private  String  alarmLevel;//'严重度',
	@Column(name = "alarm_reason")
	private  String  alarmReason;// '告警原因',
	@Column(name = "alarm_source_ip")
	private  String  alarmSourceIp;//'告警源ip',
	@Column(name = "alarm_source_name")
	private  String  alarmSourceName;//'告警名称',
	@Column(name = "alarm_source_type")
	private  String  alarmSourceType;//'告警类别',
	@Column(name = "current_state")
	private  String  currentState;//'当前状态',
	@Column(name = "happen_date")
	private  String  happenDate;//'产生时间',
	@Column(name = "continue_date")
	private  String  continueDate;//' 持续时间',
	@Column(name = "ensure_date")
	private  String  ensureDate;//'确认时间',
	@Column(name = "ensure_person")
	private  String  ensurePerson;//'确认人',
	@Column(name = "clear_date")
	private  String  clearDate;//'清楚时间',
	@Column(name = "clear_person")
	private  String  clearPerson;//'清楚人',
	@Column(name = "query_column")
	private  String  queryColumn;//'用于查询',
	
	@Column(name = "org_code")
	private  String  orgCode;//'用于查询',
	
	@Column(name = "update_date")
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private  String  updateDate;//'用于查询',
	
	
	public String getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(String updateDate) {
		this.updateDate = updateDate;
	}
	public String getOrgCode() {
		return orgCode;
	}
	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getSourceId() {
		return sourceId;
	}
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
	public String getAlarmLevel() {
		return alarmLevel;
	}
	public void setAlarmLevel(String alarmLevel) {
		this.alarmLevel = alarmLevel;
	}
	public String getAlarmReason() {
		return alarmReason;
	}
	public void setAlarmReason(String alarmReason) {
		this.alarmReason = alarmReason;
	}
	public String getAlarmSourceIp() {
		return alarmSourceIp;
	}
	public void setAlarmSourceIp(String alarmSourceIp) {
		this.alarmSourceIp = alarmSourceIp;
	}
	public String getAlarmSourceName() {
		return alarmSourceName;
	}
	public void setAlarmSourceName(String alarmSourceName) {
		this.alarmSourceName = alarmSourceName;
	}
	public String getAlarmSourceType() {
		return alarmSourceType;
	}
	public void setAlarmSourceType(String alarmSourceType) {
		this.alarmSourceType = alarmSourceType;
	}
	public String getCurrentState() {
		return currentState;
	}
	public void setCurrentState(String currentState) {
		this.currentState = currentState;
	}
	public String getHappenDate() {
		return happenDate;
	}
	public void setHappenDate(String happenDate) {
		this.happenDate = happenDate;
	}
	public String getContinueDate() {
		return continueDate;
	}
	public void setContinueDate(String continueDate) {
		this.continueDate = continueDate;
	}
	public String getEnsureDate() {
		return ensureDate;
	}
	public void setEnsureDate(String ensureDate) {
		this.ensureDate = ensureDate;
	}
	public String getEnsurePerson() {
		return ensurePerson;
	}
	public void setEnsurePerson(String ensurePerson) {
		this.ensurePerson = ensurePerson;
	}
	public String getClearDate() {
		return clearDate;
	}
	public void setClearDate(String clearDate) {
		this.clearDate = clearDate;
	}
	public String getClearPerson() {
		return clearPerson;
	}
	public void setClearPerson(String clearPerson) {
		this.clearPerson = clearPerson;
	}
	public String getQueryColumn() {
		return queryColumn;
	}
	public void setQueryColumn(String queryColumn) {
		this.queryColumn = queryColumn;
	}
	
	
}
