package com.yeejoin.amos.bank.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.bank.entity.BaseEntity;
import com.yeejoin.amos.spc.dao.entity.BasicEntity;

@Entity
@Table(name="p_alarm_point")
public class AlarmPoint {
		
	/**
	 * 
	 */
	private static final long serialVersionUID = 5191299540189393188L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "id",nullable=false,unique=true)
	private Long id;

	@Column(name = "point_id")
	private Long pointId;
	
	@Column(name = "update_date")
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date updateDate;
	
	@Column(name = "is_alarm")
	private Integer isAlarm = 1;//0 正常|1 告警
	
	@Column(name = "point_type")
	private String pointType;
	
	@Column(name = "content")
	private String content;//告警内容
	

	@Column(name = "code")
	private String code;//code
	
	@Column(name = "point_name")
	private String pointName;
	
	@Column(name = "source_id")
	private String sourceId;
	
	@Column(name = "auth_org")
	private String authOrg;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "point_attrs")
	private String pointAttrs;//告警点信息


	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public Integer getIsAlarm() {
		return isAlarm;
	}

	public void setIsAlarm(Integer isAlarm) {
		this.isAlarm = isAlarm;
	}

	public String getPointType() {
		return pointType;
	}

	public void setPointType(String pointType) {
		this.pointType = pointType;
	}

	public Long getPointId() {
		return pointId;
	}

	public void setPointId(Long pointId) {
		this.pointId = pointId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getPointAttrs() {
		return pointAttrs;
	}

	public void setPointAttrs(String pointAttrs) {
		this.pointAttrs = pointAttrs;
	}

	public String getPointName() {
		return pointName;
	}

	public void setPointName(String pointName) {
		this.pointName = pointName;
	}

	/**
	 * @return the sourceId
	 */
	public String getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId the sourceId to set
	 */
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getAuthOrg() {
		return authOrg;
	}

	public void setAuthOrg(String authOrg) {
		this.authOrg = authOrg;
	}

}
