package com.yeejoin.amos.spc.bo;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.spc.bo.extend.RiskSourceExtend;

public class RiskSourceBo extends RiskSourceExtend {

    /**
     *
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 等级id
     */
    private Long riskLevel;

    /**
     * 风险等级值([])
     */
    private String riskLevelValue;

    /**
     * 编号
     */
    private String code;

    /**
     * 类型（厂区/区域/位置/风险）
     */
    private String riskType;

    /**
     * 辨识人id
     */
    private String userId;

    /**
     * 辨识方法id
     */
    private Long identificationMethodId;

    /**
     * 三维坐标信息：{"x":168.4586,"y":1.1004,"z":30.3959}
     */
    private String position3d;

    /**
     * 信息楼层
     */
    private String floor3d;

    /**
     * 室内室外：1 为室内，0为室外
     */
    private Boolean isIndoor;

    /**
     * 分类：固定/移动。
     */
    private String classify;

    /**
     * 创建人id
     */
    private String creatorId;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 所属组织编码
     */
    private String orgCode;

    /**
     *
     */
    private Date updateDate;

    /**
     *
     */
    private Long parentId;

    /**
     * 隐患排查状态：1 合格2不合格3漏检
     */
    private String checkStatus;

    /**
     * 是否有隐患
     */
    private Boolean isDanger;

    /**
     * 1一般隐患，2重大隐患
     */
    private String dangerLevel;

    private String belongDepartmentId;

    //评价模型ID
    private Long evaluateModelId;
    
    /**
     * 闪烁频率
    */
    private Integer flickerFrequency;
    
    private List<RiskSourceBo> children;
    
    public void setId(Long id){
        this.id = id;
    }

    public Long getId(){
        return id;
    }

    public void setName(String name){
        this.name = name;
    }

    public String getName(){
        return name;
    }

    public void setRiskLevel(Long riskLevel){
        this.riskLevel = riskLevel;
    }

    public Long getRiskLevel(){
        return riskLevel;
    }

    public void setRiskLevelValue(String riskLevelValue){
        this.riskLevelValue = riskLevelValue;
    }

    public String getRiskLevelValue(){
        return riskLevelValue;
    }

    public void setCode(String code){
        this.code = code;
    }

    public String getCode(){
        return code;
    }

    public void setRiskType(String riskType){
        this.riskType = riskType;
    }

    public String getRiskType(){
        return riskType;
    }

    public void setUserId(String userId){
        this.userId = userId;
    }

    public String getUserId(){
        return userId;
    }

    public void setIdentificationMethodId(Long identificationMethodId){
        this.identificationMethodId = identificationMethodId;
    }

    public Long getIdentificationMethodId(){
        return identificationMethodId;
    }

    public void setPosition3d(String position3d){
        this.position3d = position3d;
    }

    public String getPosition3d(){
        return position3d;
    }

    public void setFloor3d(String floor3d){
        this.floor3d = floor3d;
    }

    public String getFloor3d(){
        return floor3d;
    }

    public void setIsIndoor(Boolean isIndoor){
        this.isIndoor = isIndoor;
    }

    public Boolean getIsIndoor(){
        return isIndoor;
    }

    public void setClassify(String classify){
        this.classify = classify;
    }

    public String getClassify(){
        return classify;
    }

    public void setCreatorId(String creatorId){
        this.creatorId = creatorId;
    }

    public String getCreatorId(){
        return creatorId;
    }

    public void setCreateDate(Date createDate){
        this.createDate = createDate;
    }

    public Date getCreateDate(){
        return createDate;
    }

    public void setOrgCode(String orgCode){
        this.orgCode = orgCode;
    }

    public String getOrgCode(){
        return orgCode;
    }

    public void setUpdateDate(Date updateDate){
        this.updateDate = updateDate;
    }

    public Date getUpdateDate(){
        return updateDate;
    }

    public void setParentId(Long parentId){
        this.parentId = parentId;
    }

    public Long getParentId(){
        return parentId;
    }

    public void setCheckStatus(String checkStatus){
        this.checkStatus = checkStatus;
    }

    public String getCheckStatus(){
        return checkStatus;
    }

    public void setIsDanger(Boolean isDanger){
        this.isDanger = isDanger;
    }

    public Boolean getIsDanger(){
        return isDanger;
    }

    public void setDangerLevel(String dangerLevel){
        this.dangerLevel = dangerLevel;
    }

    public String getDangerLevel(){
        return dangerLevel;
    }

    public String getBelongDepartmentId() {
        return belongDepartmentId;
    }

    public void setBelongDepartmentId(String belongDepartmentId) {
        this.belongDepartmentId = belongDepartmentId;
    }

	public Long getEvaluateModelId() {
		return evaluateModelId;
	}

	public void setEvaluateModelId(Long evaluateModelId) {
		this.evaluateModelId = evaluateModelId;
	}

	public List<RiskSourceBo> getChildren() {
		return children;
	}

	public void setChildren(List<RiskSourceBo> children) {
		this.children = children;
	}

	public Integer getFlickerFrequency() {
		return flickerFrequency;
	}

	public void setFlickerFrequency(Integer flickerFrequency) {
		this.flickerFrequency = flickerFrequency;
	}

}
