package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 风险等级
 * @author Administrator
 *
 */
public enum RiskSourceLevelEnum {
	one("一级","01"),
	two("二级","02"),
	three("三级","03"),
	four("四级","04"),
	five("五级","05");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskSourceLevelEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static RiskSourceLevelEnum getEnum(String code) {
		RiskSourceLevelEnum riskSourceLevelEnum = null;
		for(RiskSourceLevelEnum type: RiskSourceLevelEnum.values()) {
			if (type.getCode().equals(code)) {
				riskSourceLevelEnum = type;
				break;
			}
		}
		
		return riskSourceLevelEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(RiskSourceLevelEnum e : RiskSourceLevelEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
