package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 风险类型定义
 * 分为区域和风险源，区域不可添加危险因素，风险源可添加危险因素
 * @author Administrator
 *
 */
public enum RiskSourceTypeEnum {
	work("厂区","01"),
	region("区域","02"),
	position("位置","03"),
	risk("危险源","04");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskSourceTypeEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static RiskSourceTypeEnum getEnum(String code) {
		RiskSourceTypeEnum RiskSourceTypeEnum = null;
		for(RiskSourceTypeEnum type: RiskSourceTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				RiskSourceTypeEnum = type;
				break;
			}
		}
		
		return RiskSourceTypeEnum;
	}

	public static String getEnumName(String code) {
		String name = "";
		for(RiskSourceTypeEnum type: RiskSourceTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				name = type.getName();
				break;
			}
		}
		
		return name;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(RiskSourceTypeEnum e : RiskSourceTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
