package com.yeejoin.amos.spc.core.common.response;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;

/**
 * <pre>
 * 三维视图节点元素
 * </pre>
 */
public class Node3DVoResponse implements Serializable{


    protected String id;

    private String key;
    /**
     * 设备名称
     */
    private String label;


    /**
     * 类型，nodeVo中填充View3DNodeType中的name值
     */
    private String type;
    /**
     * 等级
     */
    private String level;
    /**
     * "level_0"
     */
    private String levelStr;
    /**
     * 所属模型，例如floor_1’，‘floor_2’，‘floor_3’
     */
    private String objKey;
    /**
     * 显示图标
     */
    private String displayIcon;

    /**
     * 节点位置，{x: 17.6681, y: 39.7036, z: 13.8012}
     */
    private String positionDTO;

    /**
     * 节点位置，{x: 0, y: 0, z: 0}
     */
    private String rotationDTO;

    /**
     * 节点位置，{x: 1, y: 1, z: 1}
     */
    private String scaleDTO;

    /**
     * 节点位置，包括x,y,z值
     */
    private CoordDTO position;

    /**
     * 节点位置，包括x,y,z值
     */
    private CoordDTO rotation;

    /**
     * 节点位置，包括x,y,z值
     */
    private CoordDTO scale;

    /**
     * 显示图标闪烁标题
     */
    private Boolean showInfo = false;

    /**
     * 显示图标闪烁
     */
    private Boolean twinkle = false;


    /**
     * 显示图标闪烁标题
     */
    private String title;

    /**
     * 点编号
     */
    private String dataCode;

    /**
     * 点等级
     */
    private String dataLevel;

    /**
     * 保护对象名称
     */
    private String protectObjName;


    /**
     * 是否室内（默认false，为室外）
     */
    private Boolean isDoor = false;


    private String orgCode;

    /**
     * 闪烁频率每秒
     */
    private int rate = 0;
    /**
     * 视频url
     */
    private String url;
    
    /**
	 * 点的类型
	 */
	private String objType;
	/**
	 * iot点id
	 */
	private String sourceId;

    /**
     * 视频token
     */
	private String token;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getRate() {
        return rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public String getId() {
        return id;
    }


    public void setId(String id) {
        this.id = id;
    }


    public String getLabel() {
        return label;
    }


    public void setLabel(String label) {
        this.label = label;
    }


    public String getType() {
        return type;
    }


    public void setType(String type) {
        this.type = type;
    }


    public String getLevel() {
        return level;
    }


    public void setLevel(String level) {
        this.level = level;
    }


    public String getLevelStr() {
        return levelStr;
    }


    public void setLevelStr(String levelStr) {
        this.levelStr = levelStr;
    }


    public String getObjKey() {
        return objKey;
    }


    public void setObjKey(String objKey) {
        this.objKey = objKey;
    }


    public String getDisplayIcon() {
        return displayIcon;
    }


    public void setDisplayIcon(String displayIcon) {
        this.displayIcon = displayIcon;
    }

    public Boolean getShowInfo() {
        return showInfo;
    }


    public void setShowInfo(Boolean showInfo) {
        this.showInfo = showInfo;
    }


    public Boolean getTwinkle() {
        return twinkle;
    }


    public void setTwinkle(Boolean twinkle) {
        this.twinkle = twinkle;
    }


    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }


    public String getDataCode() {
        return dataCode;
    }


    public void setDataCode(String dataCode) {
        this.dataCode = dataCode;
    }


    public String getDataLevel() {
        return dataLevel;
    }


    public void setDataLevel(String dataLevel) {
        this.dataLevel = dataLevel;
    }


    public String getProtectObjName() {
        return protectObjName;
    }


    public void setProtectObjName(String protectObjName) {
        this.protectObjName = protectObjName;
    }


    public Boolean getIsDoor() {
        return isDoor;
    }


    public void setIsDoor(Boolean isDoor) {
        this.isDoor = isDoor;
    }


    public String getOrgCode() {
        return orgCode;
    }


    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    public String getKey() {
        return key;
    }


    public void setKey(String key) {
        this.key = key;
    }


    public String getPositionDTO() {
        return positionDTO;
    }


    public void setPositionDTO(String positionDTO) {
        this.positionDTO = positionDTO;
    }


    public String getRotationDTO() {
        return rotationDTO;
    }


    public void setRotationDTO(String rotationDTO) {
        this.rotationDTO = rotationDTO;
    }


    public String getScaleDTO() {
        return scaleDTO;
    }


    public void setScaleDTO(String scaleDTO) {
        this.scaleDTO = scaleDTO;
    }


    public CoordDTO getPosition() {
        return positionDTO == null ? null : JSON.parseObject(positionDTO, CoordDTO.class);
    }


    public void setPosition(CoordDTO position) {
        this.position = position;
    }


    public CoordDTO getRotation() {
        return rotationDTO == null ? null : JSON.parseObject(rotationDTO, CoordDTO.class);
    }


    public void setRotation(CoordDTO rotation) {
        this.rotation = rotation;
    }


    public CoordDTO getScale() {
        return scaleDTO == null ? null : JSON.parseObject(scaleDTO, CoordDTO.class);
    }


    public void setScale(CoordDTO scale) {
        this.scale = scale;
    }

	/**
	 * @return the objType
	 */
	public String getObjType() {
		return objType;
	}

	/**
	 * @param objType the objType to set
	 */
	public void setObjType(String objType) {
		this.objType = objType;
	}

	/**
	 * @return the sourceId
	 */
	public String getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId the sourceId to set
	 */
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
 
