package com.yeejoin.amos.spc.dao.entity;

import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;
import java.util.List;


/**
 * 危险源(新)
 *
 */
@Entity
@Table(name="r_risk_source")
@NamedQuery(name="RRiskSource.findAll", query="SELECT s FROM RRiskSource s")
public class RRiskSource extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 分类：固定/移动 web默认添加为固定
	 */
	private String classify="01";

	/**
	 * 编码
	 */
	private String code;



	private String floor3d;

	@Column(name = "is_indoor")
	private Boolean isIndoor;


	@Column(name = "parent_id")
	private Long parentId;

	/**
	 * 辨识人id
	 */
	@Column(name="identify_user")
	private String identifyUser;

	private String username;

	/**
	 * 辨识方法id
	 */
	@Column(name="identification_method_id")
	private Long identificationMethodId;

	private String identificationMethodName;

	@Column(name="org_code")
	private String orgCode;

	/**
	 * -177.0789,0,21.6566(x,y,z)
	 */
	private String position3d;

	/**
	 * 等级
	 */
	@Column(name="risk_level_id")
	private Long riskLevelId;

	/**
	 * 类型分为:区域和风险源
	 */
	@Column(name="risk_type")
	private String riskType;

	/**
	 * 检查状态1合格2不合格3漏检
	 */
	@Column(name="check_status")
	private String checkStatus="1";

	/**
	 * 是否有隐患
	 */
	@Column(name="is_danger")
	private Boolean isDanger = false;

	/**
	 * 创建者
	 */
	@Column(name="create_by")
	private String createBy;

	@Column(name="danger_level")
	private String dangerLevel;

	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;

	@Column(name="flicker_frequency")
	private Integer flickerFrequency;

	private String markType;


	private List<RRiskSource> children;

	public RRiskSource() {
	}

	public Boolean getIsDanger() {
		return isDanger;
	}

	public void setIsDanger(Boolean isDanger) {
		this.isDanger = isDanger;
	}

	public Integer getFlickerFrequency() {
		return flickerFrequency;
	}

	public void setFlickerFrequency(Integer flickerFrequency) {
		this.flickerFrequency = flickerFrequency;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getFloor3d() {
		return this.floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getIdentificationMethodId() {
		return this.identificationMethodId;
	}

	public void setIdentificationMethodId(Long identificationMethodId) {
		this.identificationMethodId = identificationMethodId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPosition3d() {
		return this.position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public Long getRiskLevelId() { return riskLevelId; }

	public void setRiskLevelId(Long riskLevelId) { this.riskLevelId = riskLevelId; }

	public String getRiskType() {
		return this.riskType;
	}

	public void setRiskType(String riskType) {
		this.riskType = riskType;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getIdentifyUser() {
		return identifyUser;
	}

	public void setIdentifyUser(String identifyUser) {
		this.identifyUser = identifyUser;
	}

	public String getCheckStatus() {
		return checkStatus;
	}

	public void setCheckStatus(String checkStatus) {
		this.checkStatus = checkStatus;
	}

	@Transient
	public List<RRiskSource> getChildren() {
		return children;
	}

	public void setChildren(List<RRiskSource> children) {
		this.children = children;
	}

	@Transient
	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	@Transient
	public String getIdentificationMethodName() {
		return identificationMethodName;
	}

	public void setIdentificationMethodName(String identificationMethodName) {
		this.identificationMethodName = identificationMethodName;
	}

	public String getDangerLevel() {
		return dangerLevel;
	}

	public void setDangerLevel(String dangerLevel) {
		this.dangerLevel = dangerLevel;
	}

	@Transient
	public String getMarkType() {
		return markType;
	}


	public void setMarkType(String markType) {
		this.markType = markType;
	}
}