package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;


/**
 * The persistent class for the spc_equipment database table.
 */
@Entity
@Table(name = "spc_equipment")
@NamedQuery(name = "SpcEquipment.findAll", query = "SELECT s FROM SpcEquipment s")
public class SpcEquipment extends BasicEntity {
    private static final long serialVersionUID = 1L;

    private String code;

    @Column(name = "creator_id")
    private String creatorId;

    @Column(name = "department_id")
    private String departmentId;

    private String floor3d;

    private String height = "";
	
	@Column(name = "is_indoor")
	private Boolean isIndoor;

    private String name;

    @Column(name = "org_code")
    private String orgCode;

    private String position3d;

    @Column(name = "region_id")
    private String regionId;

    private String type;

    @Column(name = "workshop_section")
    private String workshopSection;

    @Transient
    private int cameraCount = 0;

    @Column(name = "equipment_number")
    private String equipmentNumber;

    @Column(name = "company_leader_user_id")
    private String companyLeaderUserId;

    @Column(name = "dept_leader_user_id")
    private String deptLeaderUserId;

    @Column(name = "shop_leader_user_id")
    private String shopLeaderUserId;

    @Column(name = "class_leader_user_id")
    private String classLeaderUserId;

    @Column(name = "is_special")
    private Integer isSpecial;

    @Column(name = "main_medium")
    private String mainMedium;

    @Column(name = "run_parameter")
    private String runParameter;

    private String regionDepartmentName;

    private String departmentName;
    
    private String markType;

    @Column(name = "company_leader_user_real_name")
    private String companyLeaderUserRealName;

    @Column(name = "dept_leader_user_real_name")
    private String deptLeaderUserRealName;

    @Column(name = "shop_leader_user_real_name")
    private String shopLeaderUserRealName;

    @Column(name = "class_leader_user_real_name")
    private String classLeaderUserRealName;

    private Long riskSourceId;

    public SpcEquipment() {
    }

    @Transient
    public String getRegionDepartmentName() {
        return regionDepartmentName;
    }

    public void setRegionDepartmentName(String regionDepartmentName) {
        this.regionDepartmentName = regionDepartmentName;
    }

    @Transient
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getFloor3d() {
        return this.floor3d;
    }

    public void setFloor3d(String floor3d) {
        this.floor3d = floor3d;
    }

    public String getHeight() {
        return this.height;
    }
	
	public Boolean getIsIndoor() {
		return isIndoor;
	}

    public void setHeight(String height) {
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getPosition3d() {
        return this.position3d;
    }

    public void setPosition3d(String position3d) {
        this.position3d = position3d;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWorkshopSection() {
        return this.workshopSection;
    }

    public void setWorkshopSection(String workshopSection) {
        this.workshopSection = workshopSection;
    }

    @Transient
    public int getCameraCount() {
        return cameraCount;
    }

    public void setCameraCount(int cameraCount) {
        this.cameraCount = cameraCount;
    }

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	@Transient
	public String getMarkType() {
		return markType;
	}

	public void setMarkType(String markType) {
		this.markType = markType;
	}

    public String getEquipmentNumber() {
        return equipmentNumber;
    }

    public void setEquipmentNumber(String equipmentNumber) {
        this.equipmentNumber = equipmentNumber;
    }

    public String getCompanyLeaderUserId() {
        return companyLeaderUserId;
    }

    public void setCompanyLeaderUserId(String companyLeaderUserId) {
        this.companyLeaderUserId = companyLeaderUserId;
    }

    public String getDeptLeaderUserId() {
        return deptLeaderUserId;
    }

    public void setDeptLeaderUserId(String deptLeaderUserId) {
        this.deptLeaderUserId = deptLeaderUserId;
    }

    public String getShopLeaderUserId() {
        return shopLeaderUserId;
    }

    public void setShopLeaderUserId(String shopLeaderUserId) {
        this.shopLeaderUserId = shopLeaderUserId;
    }

    public String getClassLeaderUserId() {
        return classLeaderUserId;
    }

    public void setClassLeaderUserId(String classLeaderUserId) {
        this.classLeaderUserId = classLeaderUserId;
    }

    public Integer getIsSpecial() {
        return isSpecial;
    }

    public void setIsSpecial(Integer isSpecial) {
        this.isSpecial = isSpecial;
    }

    public String getMainMedium() {
        return mainMedium;
    }

    public void setMainMedium(String mainMedium) {
        this.mainMedium = mainMedium;
    }

    public String getRunParameter() {
        return runParameter;
    }

    public void setRunParameter(String runParameter) {
        this.runParameter = runParameter;
    }

    public String getCompanyLeaderUserRealName() {
        return companyLeaderUserRealName;
    }

    public void setCompanyLeaderUserRealName(String companyLeaderUserRealName) {
        this.companyLeaderUserRealName = companyLeaderUserRealName;
    }

    public String getDeptLeaderUserRealName() {
        return deptLeaderUserRealName;
    }

    public void setDeptLeaderUserRealName(String deptLeaderUserRealName) {
        this.deptLeaderUserRealName = deptLeaderUserRealName;
    }

    public String getShopLeaderUserRealName() {
        return shopLeaderUserRealName;
    }

    public void setShopLeaderUserRealName(String shopLeaderUserRealName) {
        this.shopLeaderUserRealName = shopLeaderUserRealName;
    }

    public String getClassLeaderUserRealName() {
        return classLeaderUserRealName;
    }

    public void setClassLeaderUserRealName(String classLeaderUserRealName) {
        this.classLeaderUserRealName = classLeaderUserRealName;
    }

    @Transient
    public Long getRiskSourceId() {
        return riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }
}