package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * The persistent class for the spc_identification_method database table.
 * 
 */
@Entity
@Table(name="spc_identification_method")
@NamedQuery(name="SpcIdentificationMethod.findAll", query="SELECT s FROM SpcIdentificationMethod s")
public class SpcIdentificationMethod extends BasicEntity {
	private static final long serialVersionUID = 1L;

	private String code;


	private String description;

	private String name;
	
	@Column(name="creator_id")
	private String creatorId;


	@Column(name="org_code")
	private String orgCode;

	@LastModifiedDate
	@Column(name="update_date")
	private Date updateDate;

	public SpcIdentificationMethod() {
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

}