package com.yeejoin.amos.spc.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * 风险因素
 */
@Entity
@Table(name = "spc_risk_factors")
@NamedQuery(name = "SpcRiskFactor.findAll", query = "SELECT s FROM SpcRiskFactor s")
public class SpcRiskFactor extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 风险因素名称
     */
    private String name;


    /**
     * 管控对象类型（设备设施/作业活动）
     */
    @Column(name = "type")
    private String type;


    /**
     * 等级id
     */
    @Column(name = "level_id")
    private Long levelId;

    /**
     * 辨识人
     */
    @Column(name = "user_ids")
    private String userIds = "";

    @Column(name = "user_names")
    private String userNames;

    /**
     * 风险辨识方法id
     */
    @Column(name = "identification_method_ids")
    private String identificationMethodIds;

    /**
     * 危险源
     */
    @Column(name = "risk_source_id")
    private Long riskSourceId;

    /**
     * 状态：流程状态
     */
    private String status = "0";

    /**
     * 流程工单号
     */
    @Column(name = "flow_order_no")
    private String flowOrderNo;

    /**
     * 创建人
     */
    @Column(name = "creator_id")
    private String creatorId = "";

    /**
     * 流程id
     */
    @Column(name = "evaluate_id")
    private Long evaluateId = 0L;

    /**
     * 危险源分类id
     */
    @Column(name = "hazard_source_classify_id")
    private Long hazardSourceClassifyId = 0L;

    /**
     * 可能造成的后果
     */
    @Column(name = "aftermath_ids")
    private String aftermathIds = "";

    /**
     * 评价值：{"L":1,"S":5,.....}
     */
    @Column(name = "rf_value")
    private String rfValue;

    /**
     * 工单发起时间
     */
    @Column(name = "start_flow_time")
    private Date startFlowTime;

    /**
     * 工单发起人
     */
    @Column(name = "start_flow_user_id")
    private String startFlowUserId;

    @Column(name = "start_flow_department_id")
    private String startFlowDepartmentId;

    /**
     * 管控对象id：equipmentId,taskwork_content_id（作业活动步骤id）
     */
    @Column(name = "control_object_id")
    private Long controlObjectId = 0L;

    @LastModifiedDate
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 风险辨识方法名称（多个以逗号分隔）
     */
    @Column(name = "identification_method_names")
    private String identificationMethodNames;

    /**
     * 风险管控对象名称（多个以逗号隔开）
     */
    @Column(name = "control_object_name")
    private String controlObjectName = "";

    /**
     * 风险管控状态
     */
    @Column(name = "control_status")
    private String controlStatus = "受控";

    @Column(name = "evaluate_result")
    private String evaluateResult;

    @Column(name = "first_evaluate_user_id")
    private String firstEvaluateUserId;

    @Column(name = "first_evaluate_mothod_name")
    private String firstEvaluateMothodName;

    @Column(name = "second_evaluate_user_id")
    private String secondEvaluateUserId;

    @Column(name = "second_evaluate_mothod_name")
    private String secondEvaluateMothodName;

    @Column(name = "is_acceptable")
    private Integer isAcceptable;
    
    private Long evaluateModelId;

    public SpcRiskFactor() {
    }

    public Long getControlObjectId() {
        return this.controlObjectId;
    }

    public void setControlObjectId(Long controlObjectId) {
        this.controlObjectId = controlObjectId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public Long getEvaluateId() {
        return this.evaluateId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEvaluateId(Long evaluateId) {
        this.evaluateId = evaluateId;
    }

    public Long getHazardSourceClassifyId() {
        return this.hazardSourceClassifyId;
    }

    public void setHazardSourceClassifyId(Long hazardSourceClassifyId) {
        this.hazardSourceClassifyId = hazardSourceClassifyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRfValue() {
        return this.rfValue;
    }

    public void setRfValue(String rfValue) {
        this.rfValue = rfValue;
    }

    public Long getRiskSourceId() {
        return this.riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }


    public String getUserIds() {
        return userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public String getUserNames() {
        return userNames;
    }

    public void setUserNames(String userNames) {
        this.userNames = userNames;
    }

    public String getIdentificationMethodIds() {
        return identificationMethodIds;
    }

    public void setIdentificationMethodIds(String identificationMethodIds) {
        this.identificationMethodIds = identificationMethodIds;
    }

    public String getIdentificationMethodNames() {
        return identificationMethodNames;
    }

    public void setIdentificationMethodNames(String identificationMethodNames) {
        this.identificationMethodNames = identificationMethodNames;
    }

    public String getFlowOrderNo() {
        return flowOrderNo;
    }

    public void setFlowOrderNo(String flowOrderNo) {
        this.flowOrderNo = flowOrderNo;
    }

    public Date getStartFlowTime() {
        return startFlowTime;
    }

    public void setStartFlowTime(Date startFlowTime) {
        this.startFlowTime = startFlowTime;
    }

    public String getStartFlowUserId() {
        return startFlowUserId;
    }

    public void setStartFlowUserId(String startFlowUserId) {
        this.startFlowUserId = startFlowUserId;
    }

    public String getControlObjectName() {
        return controlObjectName;
    }

    public void setControlObjectName(String controlObjectName) {
        this.controlObjectName = controlObjectName;
    }

    public String getControlStatus() {
        return controlStatus;
    }

    public void setControlStatus(String controlStatus) {
        this.controlStatus = controlStatus;
    }

    public String getAftermathIds() {
        return aftermathIds;
    }

    public void setAftermathIds(String aftermathIds) {
        this.aftermathIds = aftermathIds;
    }

    public String getEvaluateResult() {
        return evaluateResult;
    }

    public void setEvaluateResult(String evaluateResult) {
        this.evaluateResult = evaluateResult;
    }

    public String getFirstEvaluateUserId() {
        return firstEvaluateUserId;
    }

    public void setFirstEvaluateUserId(String firstEvaluateUserId) {
        this.firstEvaluateUserId = firstEvaluateUserId;
    }

    public String getSecondEvaluateUserId() {
        return secondEvaluateUserId;
    }

    public void setSecondEvaluateUserId(String secondEvaluateUserId) {
        this.secondEvaluateUserId = secondEvaluateUserId;
    }

    public String getFirstEvaluateMothodName() {
        return firstEvaluateMothodName;
    }

    public void setFirstEvaluateMothodName(String firstEvaluateMothodName) {
        this.firstEvaluateMothodName = firstEvaluateMothodName;
    }

    public String getSecondEvaluateMothodName() {
        return secondEvaluateMothodName;
    }

    public void setSecondEvaluateMothodName(String secondEvaluateMothodName) {
        this.secondEvaluateMothodName = secondEvaluateMothodName;
    }

    public String getStartFlowDepartmentId() {
        return startFlowDepartmentId;
    }

    public void setStartFlowDepartmentId(String startFlowDepartmentId) {
        this.startFlowDepartmentId = startFlowDepartmentId;
    }

    public Integer getIsAcceptable() {
        return isAcceptable;
    }

    public void setIsAcceptable(Integer isAcceptable) {
        this.isAcceptable = isAcceptable;
    }

    public Long getLevelId() {
        return levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    @Transient
	public Long getEvaluateModelId() {
		return evaluateModelId;
	}

	public void setEvaluateModelId(Long evaluateModelId) {
		this.evaluateModelId = evaluateModelId;
	}

}