package com.yeejoin.amos.spc.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;


/**
 * The persistent class for the spc_risk_factors_level_log database table.
 */
@Entity
@Table(name = "spc_risk_factors_level_log")
@NamedQuery(name = "SpcRiskFactorsLevelLog.findAll", query = "SELECT s FROM SpcRiskFactorsLevelLog s")
public class SpcRiskFactorsLevelLog extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "current_level_id")
    private Long currentLevelId;

    @Column(name = "evaluate_id")
    private Long evaluateId;

    @Column(name = "old_level_id")
    private Long oldLevelId;

    @Column(name = "risk_factors_id")
    private Long riskFactorsId;

    private int type;

    private String value;

    private String levelCode;

    @Column(name = "is_acceptable")
    private Integer isAcceptable;

    public SpcRiskFactorsLevelLog() {
    }

    public Long getCurrentLevelId() {
        return currentLevelId;
    }

    public void setCurrentLevelId(Long currentLevelId) {
        this.currentLevelId = currentLevelId;
    }

    public Long getEvaluateId() {
        return evaluateId;
    }

    public void setEvaluateId(Long evaluateId) {
        this.evaluateId = evaluateId;
    }

    public Long getOldLevelId() {
        return oldLevelId;
    }

    public void setOldLevelId(Long oldLevelId) {
        this.oldLevelId = oldLevelId;
    }

    public Long getRiskFactorsId() {
        return riskFactorsId;
    }

    public void setRiskFactorsId(Long riskFactorsId) {
        this.riskFactorsId = riskFactorsId;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Transient
    public String getLevelCode() {
        return levelCode;
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }

    public Integer getIsAcceptable() {
        return isAcceptable;
    }

    public void setIsAcceptable(Integer isAcceptable) {
        this.isAcceptable = isAcceptable;
    }
}