package com.yeejoin.amos.bank.config;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.spc.core.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.bank.common.enums.DevicePointEnum;
import com.yeejoin.amos.bank.entity.EquipmentQualityVo;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;

@Component
public class DeviceListener extends EmqxListener implements InitializingBean {

    private static final Logger logger = Logger.getLogger(DeviceListener.class);

    private static ObjectMapper mapper = new ObjectMapper();
    
    //临界温度
    private static final double CRITICAL_TEMPERATURE = 35;



    @Autowired
    private EmqKeeper emqKeeper;

    private static TaskExecutor taskExecutor;

    @Autowired
    EquipmentMapper equipmentMapper;

    @Autowired
    RiskModelRemoteClient riskModelRemoteClient;


    /**
     * 监听主题
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        emqKeeper.subscript(CommTopic.SHIDU_DEVICE.getTopic(), 2, this);
    }

    /**
     * 接收主题下的消息
     */
    @Override
    public void processMessage(String s, MqttMessage mqttMessage) throws Exception {

        blueprintMsgtransfer(mqttMessage);
    }


    /**
     * 消息处理
     *
     * @param mqttMessage
     */
    private void blueprintMsgtransfer(MqttMessage mqttMessage) {

        try {
            String jsonStr = new String(mqttMessage.getPayload());
            System.out.println("----shidumqtt received--jsonStr:" + jsonStr);
//            logger.error("----shidumqtt received--jsonStr",jsonStr);
            JSONObject parseObject = JSON.parseObject(jsonStr);
            //logger.info("----shidumqtt received sucess",parseObject);
            System.out.println("----shidumqtt received sucess :"+ parseObject);
            Long eqpId = parseObject.getLong("eqpId");
            String eqpName = parseObject.getString("eqpName");
            JSONArray jsonArray = parseObject.getJSONArray("metricDatas");
            if (ObjectUtils.isEmpty(jsonArray)) {
                return;
            }
            jsonArray.forEach(e -> {
                JSONObject object = (JSONObject) e;
                String string = object.getString("metricJson");
                if (!StringUtil.isNotEmpty(string)) {
                    return;
                }
                logger.error("---------shudu--string"+ string);
                System.out.println("----shidumqtt chuli recording : " + string);
                //{"describe":"A中心机房-机房温湿度监测-温度过高报警-报警值:35℃","temperatureAlarm":"正常","humidityAlarm":"正常"}
                JSONObject metricJson = JSONObject.parseObject(string);
				for (Map.Entry entry : metricJson.entrySet()) {
					// 指标名
					System.out.println("----start chuli device state : "+ entry);
					String remark = entry.getKey().toString();
					String statusName = entry.getValue().toString();
					if (remark.equals("temperature")) {
						System.out.println("----start chuli device temperature : "+ remark);
						EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
						Long equipmentsPointId = queryEquipmentPoint.getId();
						System.out.println("----shudu equipmentsPointId  : "+ equipmentsPointId);
						List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);
						Integer value = 0;
						
						if (Double.valueOf(statusName) >= CRITICAL_TEMPERATURE) {
							value = DevicePointEnum.getValue("异常");
							equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
						} else {
							value = DevicePointEnum.getValue("正常");
							equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
						}
						System.out.println("----shudu riskFactorId  : "+ riskFactorId);
						
						
						
						
						for (int j = 0; j < riskFactorId.size(); j++) {
							try {
								riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j),eqpName,value);
								System.out.println("----udpate riskFactor sucess");
							} catch (InnerInvokException e1) {
								logger.error("update rpn fail " + e1.getMessage());
							}
						}
					}
					
					 if (remark.equals("temperatureAlarm") || remark.equals("humidityAlarm")) {
						    System.out.println("----start chuli device temperatureAlarm : "+ remark);
	                        EquipmentQualityVo queryEquipmentPoint = equipmentMapper.queryEquipmentPoint(eqpId, remark);
	                        System.out.println("----update device queryEquipmentPoint :"+ queryEquipmentPoint);
	                        Long equipmentsPointId = queryEquipmentPoint.getId();
	                        List<Long> riskFactorId = equipmentMapper.judgeEquipmentExists(equipmentsPointId);
	                        System.out.println("----update device riskFactorId :"+ riskFactorId);
	                        if ((remark.equals("currentState") || "异常".equals(statusName) || "正常".equals(statusName)) && !ObjectUtils.isEmpty(queryEquipmentPoint) && riskFactorId.size() > 0) {
	                        	System.out.println("----start chuli device zhuangtai.riskFactorId : "+ riskFactorId);
	                            // 指标的值 0正常 1告警
	                            Integer value = DevicePointEnum.getValue(statusName);
	                            equipmentMapper.updateEquipmentPointStatus(value, queryEquipmentPoint.getId());
	                            try {
	                                for (int j = 0; j < riskFactorId.size(); j++) {
	                                	System.out.println("----shudu riskFactorId  : "+ riskFactorId);
	                                    riskModelRemoteClient.updateEquipmentAlarmData(riskFactorId.get(j),eqpName,value);
	                                    System.out.println("----udpate riskFactor sucess");
	                                }
	                            } catch (InnerInvokException e1) {
	                                logger.error("update rpn fail " + e1.getMessage());
	                            }
	                        }else {
	                        	System.out.println("----update device state  fail  : "+ riskFactorId);
	                        }
	                    }
				}
            });

        } catch (Exception e) {
            logger.error("消息流转报错.");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }
}
