package com.yeejoin.amos.bank.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.bank.entity.MonitorParam;
import com.yeejoin.amos.bank.entity.PageModel;
import com.yeejoin.amos.bank.entity.RtspAddressBean;
import com.yeejoin.amos.bank.entity.Video;
import com.yeejoin.amos.bank.service.PageService;
import com.yeejoin.amos.bank.service.VideoService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.business.param.ReginParams;

import io.micrometer.core.instrument.util.StringUtils;

@RestController
@RequestMapping(value = "/rtsp")
public class AddressController extends BaseController{

    private static final Logger log = Logger.getLogger(AddressController.class);
	
	@Autowired
	VideoService videoService;

	@Autowired
	private PageService pageService;

	@PostMapping(value = "/address", produces = "application/json;charset=UTF-8")
	public CommonResponse getRtspAddress(@RequestBody List<RtspAddressBean> list) {
		try {
			// URL
			List<String> listUrls = new ArrayList<>();
			for (RtspAddressBean bean : list) {
				// rtsp://admin:zjt123456@172.16.18.21:554/h264/ch1/main/av_stream
				String url = "rtsp://" + bean.getUserName() + ":" + bean.getPwd() + "@" + bean.getIp() + ":"
						+ bean.getPort() + "/" + bean.getVideoFormat() + "/" + bean.getChannel() + "/main/av_stream";
				listUrls.add(url);
			}
			return CommonResponseUtil.success(listUrls);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取地址失败");
		}
	}
	
	/**
	   *  分页查询摄像头列表
	 * @param param
	 * @return
	 */
	@PostMapping(value = "/listVideoByPage", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideos(@RequestBody(required = true) MonitorParam param) {
		try {
			PageModel<Video> findRoadPageList = videoService.findPageList(param);
			return CommonResponseUtil.success(findRoadPageList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}
	
	/**
	   *  分页查询摄像头列表
	 * @param param
	 * @return
	 */
	@PostMapping(value = "/listVideoByPage/{orgCode}/{parentId}/{current}/{pageSize}", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideos1(
			@PathVariable(required = true) String orgCode,
			@PathVariable(required = true) Long parentId,
    		 @PathVariable(required = true) Integer current,
    		 @PathVariable(required = true) Integer pageSize) {
		try {
			 MonitorParam param=new MonitorParam();
			 
			 param.setOrgCode(orgCode);
			 param.setParentId(parentId);
	         param.setPageSize(pageSize);
	         param.setCurrent(current);
			PageModel<Video> findRoadPageList = videoService.findPageList(param);
			return CommonResponseUtil.success(findRoadPageList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}
	
	/**
	   * 获取所有节点列表（树结构）
	 * @return
	 */
	@GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideosList(@RequestParam("floor3d") String floor3d,@RequestParam("orgCode") String orgCode) {
		try {
			if(StringUtils.isEmpty(orgCode)) {
				return CommonResponseUtil.success(new ArrayList<Video>());
			}
			List<Video> findAll = videoService.findAll(floor3d,orgCode);
			return CommonResponseUtil.success(findAll);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}

	/**
	 * 获取所有节点列表（树结构）
	 * @return
	 */
	@GetMapping(value = "/monitorVideoTree", produces = "application/json;charset=UTF-8")
	public CommonResponse getVideosTree() {
		try {
			
			//获取当前登录人的公司code
			ReginParams reginParams	=getSelectedOrgInfo();
			
			List<Map<String, Object>> resultList = videoService.videoTree(reginParams.getCompany().getOrgCode());
			return CommonResponseUtil.success(resultList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("获取失败");
		}
	}

	/**
	 *  分页查询摄像头列表
	 * @param param
	 * @return
	 */
	@PostMapping(value = "/monitorVideoByPage", produces = "application/json;charset=UTF-8")
	public CommonResponse getPageMonitorVideo(@RequestBody(required = true) MonitorParam param){

		List list = pageService.doService(param);
		return CommonResponseUtil.success(list);
	}
}
