package com.yeejoin.amos.bank.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.bank.service.IDynamicRingDataService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/bank/dynamicRingData")
@Api(value = "/bank/dynamicRingData", tags = {"动环数据API"})
public class DynamicRingDataController extends BaseController{
	
	@Autowired
	private IDynamicRingDataService dynamicRingDataService;
	
	@GetMapping(value = "/{id}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "动环数据", notes = "动环数据")
    public CommonResponse detail(@ApiParam(value = "动环数据id", required = false) @PathVariable(value = "id")Long id) {
		String token = getToken();
        return CommonResponseUtil.success(dynamicRingDataService.queryDynamicRingDataById(id,token));
    }
	
	@Autowired
	private IAlarmPointService alar;
	@GetMapping(value = "/test", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "动环数据", notes = "动环数据")
    public CommonResponse detail() {
		AlarmPoint alarmPoint = new AlarmPoint();
		alarmPoint.setPointId(131L);
		alarmPoint.setPointType("device");
		alarmPoint.setUpdateDate(new Date());
		alar.saveItem(alarmPoint);
        return CommonResponseUtil.success();
    }

}
