package com.yeejoin.amos.bank.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.entity.DeviceRecord;
import com.yeejoin.amos.bank.entity.EquipmentVo;
import com.yeejoin.amos.bank.param.PointParam;
import com.yeejoin.amos.bank.remote.client.RiskModelRemoteClient;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.bank.service.IEquipmentService;
import com.yeejoin.amos.bank.service.WarnService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 设备Controller
 */
@RestController
@RequestMapping(value = "/bank/equipment")
@Api(value = "/bank/equipment", tags = {"设备API"})
public class EquipmentController extends BaseController{
	
    private static final Logger log = Logger.getLogger(EquipmentController.class);

	@Autowired
    private WarnService warnService;

	@Autowired
    private IEquipmentService equipmentService;
	
	@Autowired
    private IAlarmService iAlarmService;
	
	@Autowired
    RiskModelRemoteClient riskModelRemoteClient;

	
	@GetMapping(value = "/detail", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询设备", notes = "查询设备")
    public CommonResponse detail(@ApiParam(value = "设备id", required = false)Long id,@ApiParam(value = "设备类型", required = false)String type) {
        return CommonResponseUtil.success(equipmentService.queryEquipmentById(id,type,getToken()));
    }
	
	
	@GetMapping(value = "/portList", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询设备端口列表", notes = "查询设备端口列表")
    public CommonResponse portList(@ApiParam(value = "设备id", required = false)Long id,
    		@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
        return CommonResponseUtil.success(equipmentService.queryEquipmentPortListById(id,commonPageable));
    }
    
    @GetMapping(value = "/warnList", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询设备告警列表", notes = "查询设备告警列表")
    public CommonResponse warnList(@ApiParam(value = "设备sourceId", required = false)String sourceId,
    		@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
    	
    	List<DaoCriteria> daoCriterias = new ArrayList<DaoCriteria>();
        DaoCriteria criteria = new DaoCriteria();
        criteria.setPropertyName("sourceId");
        criteria.setValue(sourceId);
        criteria.setOperator(QueryOperatorEnum.EQUAL.getName());
        daoCriterias.add(criteria);
        Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
        commonPageable.setSort(sort);
        Page<Alarm> list = iAlarmService.list(daoCriterias, commonPageable);
        return CommonResponseUtil.success(list);
        
    }
    
    @GetMapping(value = "/netwoerkInterface", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "查询网络接口", notes = "查询网络接口")
    public CommonResponse netwoerkInterface(@ApiParam(value = "设备id", required = false)Long id) {
        return CommonResponseUtil.success(equipmentService.queryNetwoerkInterfaceById(id));
    }
    
    @GetMapping(value = "/synchronization", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "同步设备接口", notes = "添加设备接口")
    public CommonResponse synDevice() {
    	log.debug("synchronization deviece");
	     equipmentService.syncDeviceList();
	 	log.debug("synchronization sucess");
	      return  CommonResponseUtil.success("同步成功");
    }
    
    @GetMapping(value = "/selfDevice", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "ping设备查询", notes = "ping设备查询")
    public CommonResponse selfDevice(  @RequestParam(value = "fname", required = false) String fname,
            @RequestParam int pageNumber,
            @RequestParam int pageSize) {
    	   CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
    	  if(fname.equals("null")) {
               fname= null;
           }
    	  Page selfDevice = equipmentService.queryEquimentRelation(commonPageable,fname);
	      return CommonResponseUtil.success(selfDevice);
    }
    
    @GetMapping(value = "/pointItemEquipment", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "装备指标列表查询", notes = "装备指标列表查询")
    public CommonResponse getPointItemEquipment(@RequestParam(value = "factorId", required = false) Long factorId
           ) throws InnerInvokException {
    	  List<PointParam> handleEquipmentsPointData = equipmentService.handleEquipmentsPointData(factorId);
	      return CommonResponseUtil.success(handleEquipmentsPointData);
    }
    
    @GetMapping(value = "/pointItemPatrol", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "装备指标列表查询", notes = "装备指标列表查询")
    public CommonResponse getPointItemPatrol(@RequestParam(value = "factorId", required = false) Long factorId
           ) throws InnerInvokException {
    	  List<PointParam> handlePatrolPointData = equipmentService.handlePatrolPointData(factorId);
	      return CommonResponseUtil.success(handlePatrolPointData);
    }
    
    @GetMapping(value = "/getPointItemDatas", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "指标列表查询", notes = "指标列表查询")
    public CommonResponse getPointItemDatas(@RequestParam(value = "factorId", required = false) Long factorId
           ) throws InnerInvokException {
    	  Map<String, List> handlePointDatas = equipmentService.handlePointDatas(factorId);
	      return CommonResponseUtil.success(handlePointDatas);
    }
}
