package com.yeejoin.amos.bank.dao.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.bank.entity.Video;

@Repository
public interface VideoMapper {

	public Integer getCount(@Param("orgCode")String orgCode,@Param("name") String name, @Param("parentId") Long parentId);

	public List<Video> findPageList(@Param("orgCode")String orgCode, @Param("offset")Integer offset,@Param("pageSize") Integer pageSize,@Param("name") String name, @Param("parentId") Long parentId);
	
	/**
	 * 根据楼层查询摄像头
	 * @param floor3d
	 * @return
	 */
	public List<Video> findAll(@Param("floor3d") String floor3d,@Param("orgCode")String orgCode);

	List<Video> selectByParentId(@Param("orgCode")String orgCode);
	
    void insertVideo(Video video);
    
    void deleteVideo(@Param("token") String token);
    
    
    Video selectByToken(@Param("token") String token);
    
    void updateVideo(Video video);
    
}
