package com.yeejoin.amos.bank.service;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.bank.entity.H5Response;
import com.yeejoin.amos.bank.entity.MonitorParam;
import com.yeejoin.amos.bank.entity.PageModel;
import com.yeejoin.amos.bank.entity.Video;

public interface VideoService {

	public PageModel<Video> findPageList(MonitorParam param);
	
	List<Video> findAll(String floor3d,String orgCode);

	List<Map<String, Object>>videoTree(String code);
	
	/**
	 * 添加设备
	 * @return
	 */
	H5Response addDevice(Video bean);
	
	
	/**
	 * 删除设备
	 * @return
	 */
	H5Response deleteDevice(String token);
	
	
	/**
	 * 查询设备信息
	 * @return
	 */
	Video getDevice(String token);
	
	/**
	 * 更新设备
	 * @param bean
	 */
	public void updateDevice(Video bean);
}
