
package com.yeejoin.amos.bank.service.impl;

import com.google.common.collect.Maps;
import com.yeejoin.amos.bank.dao.entity.AlarmPoint;
import com.yeejoin.amos.bank.dao.repository.IAlarmPointRepository;
import com.yeejoin.amos.bank.remote.RemoteAlarmTiggerService;
import com.yeejoin.amos.bank.service.IAlarmPointService;
import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import com.yeejoin.amos.spc.business.dao.mapper.InputItemMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class AlarmServiceImpl extends GenericManagerImpl<AlarmPoint, String>  implements IAlarmPointService {
	
	
	@Autowired
	private IAlarmPointRepository iAlarmPointDao;
	
	@Autowired
	private InputItemMapper inputMapper;
	
	@Autowired
	private RemoteAlarmTiggerService alarmTiggerService;

	public AlarmServiceImpl(IAlarmPointRepository repository) {
		super(repository);
		this.iAlarmPointDao = repository;
	}


	@Override
	public void saveItem(AlarmPoint alarmPoint) {
		iAlarmPointDao.save(alarmPoint);
	}

	@Override
	public void deleteItem(List<AlarmPoint> alarmPoints) {
		iAlarmPointDao.deleteAll(alarmPoints);
	}

	@Override
	public void deleteItems(List<AlarmPoint> alarmPoints) {
		List<Long> ids = new ArrayList<>();
		if(null != alarmPoints && alarmPoints.size() > 0 ) {
			alarmPoints.forEach(alarmPoint -> {
				ids.add(alarmPoint.getId());
			});
//			iAlarmPointDao.deleteByIdIn(ids);
			inputMapper.deletePointAlarmByIds(ids);
		}

    }

	@Override
	public List<AlarmPoint> selectPointTypeAndPointId(String type, Long pointId) {
		
		return iAlarmPointDao.selectPointTypeAndPointId( type,  pointId);
		
	}


	@Override
	public void alarmTigger(String xmlData,String token) {
		Map<String, String> params =  Maps.newHashMap();
		params.put("xmlData", xmlData);
		String alarmTiggerGet = alarmTiggerService.sendAlarm(xmlData);
		//String alarmTiggerGet = alarmTiggerService.alarmTiggerGet(DeviceUriEnum.触发清除告警, token, params);
	}


	@Override
	public List<AlarmPoint> queryAutoInspection(String pointId,String content) {
		return iAlarmPointDao.selectPointTypeAndPointId(pointId,content);
	}
}
