
package com.yeejoin.amos.bank.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.dao.BankInfoDao;
import com.yeejoin.amos.bank.dao.mapper.AutoInspectionMapper;
import com.yeejoin.amos.bank.dao.mapper.BankInfoMapper;
import com.yeejoin.amos.bank.dao.repository.IAutoInspectionRepository;
import com.yeejoin.amos.bank.dto.BankInfoDTO;
import com.yeejoin.amos.bank.entity.AutoInspection;
import com.yeejoin.amos.bank.entity.BankInfo;
import com.yeejoin.amos.bank.service.IAutoInspectionService;
import com.yeejoin.amos.op.core.jpa.GenericManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class AutoInspectionServiceImpl extends GenericManagerImpl<AutoInspection, String> implements IAutoInspectionService {

    @Autowired
    private IAutoInspectionRepository iAutoInspectionDao;

    public AutoInspectionServiceImpl(IAutoInspectionRepository repository) {
        super(repository);
        this.iAutoInspectionDao = repository;
    }

    @Autowired
    private AutoInspectionMapper autoInspectionMapper;

    @Autowired
    private BankInfoMapper bankInfoMapper;

    @Override
    public List<AutoInspection> findAbnormalByMonitorItemNameAndHost(String monitorItemName, String monitorHostMachine) {
        return iAutoInspectionDao.findAbnormalByMonitorItemNameAndHost(monitorItemName, monitorHostMachine);
    }

    @Override
    public List<HashMap<String, Object>> aisleSummary(String city, String label) {
        List<HashMap<String, Object>> aisleSummary = autoInspectionMapper.aisleSummary(city, label);
        for (HashMap<String, Object> m : aisleSummary) {
            ArrayList<String> nameList = new ArrayList<>();
            nameList.add((String) m.get("sname"));
            String ename = (String) m.get("ename");
            nameList.add(ename);
            m.put("name", nameList);
            m.put("alias", ename);

            //起点经纬度
            String slng = (String) m.get("slng");
            String slat = (String) m.get("slat");
            JSONObject start = new JSONObject();
            if (null != slng && null != slat) {
                start.put("lng", Double.valueOf(slng));
                start.put("lat", Double.valueOf(slat));
            }
            //终点经纬度
            String elng = (String) m.get("elng");
            String elat = (String) m.get("elat");
            JSONObject end = new JSONObject();
            ArrayList<Double> center = new ArrayList<Double>();
            if (null != elat && null != elng) {
                end.put("lng", Double.valueOf(elng));
                end.put("lat", Double.valueOf(elat));
                center.add(Double.valueOf(elng));
                center.add(Double.valueOf(elat));
            }

            m.put("center", center);

            ArrayList<JSONObject> path = new ArrayList<JSONObject>();
            path.add(start);
            path.add(end);
            m.put("path", path);

        }
        return aisleSummary;
    }

    @Override
    public List<JSONObject> topoAislelist() {

        List<JSONObject> arrayList = new ArrayList<>();
        JSONObject cityInfo = new JSONObject();
        cityInfo.put("city", "西安");
        ArrayList<Double> position = new ArrayList<Double>();
        position.add(108.95d);
        position.add(34.27d);
        cityInfo.put("position", position);

        List<HashMap<String, Object>> aisleSummary = autoInspectionMapper.pamsAisleSummary();

        ArrayList<JSONObject> data = new ArrayList<>();

        HashMap<String, List<List<JSONObject>>> ailesHashMap = new HashMap<>();
        for (HashMap<String, Object> m : aisleSummary) {
            String alarmState = (String) m.get("alarmState");
            if (null != alarmState && !"".equals(alarmState)) {

                List<List<JSONObject>> list = ailesHashMap.get(alarmState);
                if (list == null) {
                    list = new ArrayList<>();
                }
                //起点经纬度
                String sname = (String) m.get("sname");
                String sPosition = (String) m.get("sPosition");
                //终点经纬度
                String ename = (String) m.get("ename");
                String ePosition = (String) m.get("ePosition");

                if (sname != null && sPosition != null && ename != null && ePosition != null) {
                    List<JSONObject> item = new ArrayList<JSONObject>();
                    JSONObject spoint = new JSONObject();
                    spoint.put("name", sname);
                    spoint.put("position", Arrays.asList(sPosition.split(",")));

                    JSONObject epoint = new JSONObject();
                    epoint.put("name", ename);
                    epoint.put("position", Arrays.asList(ePosition.split(",")));

                    item.add(spoint);
                    item.add(epoint);
                    list.add(item);
                    ailesHashMap.put(alarmState, list);
                }
            }
        }

        Iterator iter = ailesHashMap.entrySet().iterator();
        while (iter.hasNext()) {
            JSONObject alarm = new JSONObject();

            Map.Entry entry = (Map.Entry) iter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            alarm.put("name", key);
            alarm.put("data", value);
            data.add(alarm);
        }
        cityInfo.put("data", data);
        arrayList.add(cityInfo);
        return arrayList;
    }

    @Override
    public Map<String, Object> bankInfoList() {
        Map<String, Object> map = new HashMap();

        List<BankInfoDTO> bankInfoList = bankInfoMapper.selectBankInfoList();
        List<BankInfoDTO> centerList = bankInfoList.stream().filter(x -> x.getIsCenter() == 1).distinct().collect(Collectors.toList());
        List<BankInfoDTO> unCenterList = bankInfoList.stream().filter(x -> x.getIsCenter() == 0).distinct().collect(Collectors.toList());

        map.put("centerList",centerList);
        map.put("unCenterList",unCenterList);
        return map;
    }
}
