package com.yeejoin.amos.bank.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.bank.remote.client.DeviceRemoteClient;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.bank.common.enums.DeviceUriEnum;
import com.yeejoin.amos.bank.remote.RemoteDeviceService;
import com.yeejoin.amos.bank.service.IDynamicRingDataService;
import com.yeejoin.amos.bank.utils.JsonUtil;
import com.yeejoin.amos.spc.core.common.response.CoordDTO;
import com.yeejoin.amos.spc.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.spc.exception.YeeException;

import feign.Logger;

@Service
public class DynamicRingDataServiceImpl implements IDynamicRingDataService {

    @Autowired
    private RemoteDeviceService deviceService;

    @Override
    public JSONArray queryDynamicRingDataById(Long id, String token) {
        Map<String, String> params = Maps.newHashMap();
        params.put("id", String.valueOf(id));

        String dynamicRingDataGet = deviceService.selectEquipById(id);

        //String dynamicRingDataGet = deviceService.deviceDoGetWithToken(DeviceUriEnum.根据设备id查询数据详情, token, params);
        JSONObject resJson = JSONObject.parseObject(dynamicRingDataGet);
        String result = resJson.getString("result");
        if (null != result && "SUCCESS".equals(result)) {
            return resJson.getJSONArray("dataList");
        }

        return null;
    }

    @Override
    public ArrayList<Node3DVoResponse> query3dData(String token,String orgCode) {
        String params1 = "{\"eqpTempAttr\":{\"name\":\"affiliatedSystem\",\"value\":\"动环系统\"},\"pageNumber\":0,\"pageSize\":1000000000,\"needAttr\":[\"position\",\"storey\",\"storey\"]}";
        String resStr = deviceService.selectEquipments(params1);
        //String resStr = deviceService.dynamicRingData(DeviceUriEnum.查询三维设备点, token, params1);
        JSONObject resJson = JSONObject.parseObject(resStr);

        String params2 = "{\"eqpTempAttr\":{\"name\":\"affiliatedSystem\",\"value\":\"火探\"},\"pageNumber\":0,\"pageSize\":1000000000,\"needAttr\":[\"position\",\"storey\",\"storey\"]}";
        String fireDetectionStr = deviceService.selectEquipments(params2);
        //String fireDetectionStr = deviceService.dynamicRingData(DeviceUriEnum.查询三维设备点, token, params2);
        JSONObject fireDetectionJson = JSONObject.parseObject(fireDetectionStr);
        if (!"SUCCESS".equals(resJson.get("result")) || !"SUCCESS".equals(fireDetectionJson.get("result"))) {
            throw new YeeException("查询动环数据失败");
        }
        ArrayList<Node3DVoResponse> list = new ArrayList<>();

        if (resJson != null) {
            convertNode3DVoResponse(list, resJson, "01",orgCode);
        }
        if (fireDetectionJson != null) {
            convertNode3DVoResponse(list, fireDetectionJson, "02",orgCode);
        }

        return list;
    }

    private void convertNode3DVoResponse(ArrayList<Node3DVoResponse> list, JSONObject json, String type,String orgCode) {
        List<JSONObject> dataArray = (List<JSONObject>) json.get("content");
        dataArray.forEach(e -> {
        	JSONArray authOrgs = e.getJSONArray("authOrg");
        	if(!ObjectUtils.isEmpty(authOrgs)) {
        		List<String> authOrgList = JSONObject.parseArray(authOrgs.toJSONString(), String.class);
        		//确认授权才显示
        		if(authOrgList.contains(orgCode)) {
        			 try {
						Node3DVoResponse node3dVoResponse = handledata(type, e);
						list.add(node3dVoResponse);
					} catch (Exception e1) {
						System.out.println("device iot piezhi is error: " + e1.getMessage());
					}
        		}
        	}
        });
    }

	private Node3DVoResponse handledata(String type, JSONObject e) {
		Node3DVoResponse node3dVoResponse = new Node3DVoResponse();
		JSONObject paramsRes = e.getJSONObject("cfgParamJsonObject");
		node3dVoResponse.setId(e.getString("id"));
//			node3dVoResponse.setIsDoor(paramsRes.getBoolean("isDoor"));
		node3dVoResponse.setKey("dynamicRingData" + e.getString("id"));
		node3dVoResponse.setLabel(e.getString("name"));
		node3dVoResponse.setLevel(type);
		node3dVoResponse.setTitle(e.getString("name"));
		node3dVoResponse.setLevelStr("dynamicRingData_" + type);
		node3dVoResponse.setObjType(type);
		node3dVoResponse.setObjKey(paramsRes.getString("storey"));
		node3dVoResponse.setSourceId(paramsRes.getString("sourceId"));
		CoordDTO postion = new CoordDTO();
		String positonStr = paramsRes.getString("position");
		if (positonStr != null && positonStr.contains("{")) {
		    JSONObject parseObject = JSONObject.parseObject(positonStr);
		    postion.setX(parseObject.getDouble("x"));
		    postion.setY(parseObject.getDouble("y"));
		    postion.setZ(parseObject.getDouble("z"));
		} else if (positonStr != null && !"".equals(positonStr)) {
		    positonStr = positonStr.replace("[", "").replace("]", "").replace("，", ",");
		    String[] split = positonStr.split(",");
		    postion.setX(Double.valueOf(split[0]));
		    postion.setY(Double.valueOf(split[1]));
		    postion.setZ(Double.valueOf(split[2]));
		}
		node3dVoResponse.setPositionDTO(postion.toString());
		node3dVoResponse.setPosition(postion);
		node3dVoResponse.setRate(0);
		node3dVoResponse.setRotation(new CoordDTO(0d, 0d, 0d));
		node3dVoResponse.setRotationDTO(new CoordDTO(0d, 0d, 0d).toString());
		node3dVoResponse.setScale(new CoordDTO(1d, 1d, 1d));
		node3dVoResponse.setScaleDTO(new CoordDTO(1d, 1d, 1d).toString());
		node3dVoResponse.setShowInfo(false);
		node3dVoResponse.setTwinkle(false);
		node3dVoResponse.setType("dynamicRingData");
		return node3dVoResponse;
	}
    

}
